<?php

if ( ! defined( 'ABSPATH' ) ) { exit; }

global $bookingpress_global_options,$BookingPress;
$bpa_global_opts = $bookingpress_global_options->bookingpress_global_options();
$bookingpress_allow_tag = json_decode($bpa_global_opts['allowed_html'], true);
$no_payment_method_available = $BookingPress->bookingpress_get_settings('no_payment_method_available', 'message_setting');
$no_timeslots_available = $BookingPress->bookingpress_get_settings('no_timeslots_available','message_setting');
$no_timeslots_available = stripslashes_deep( $no_timeslots_available );
$bookingpress_date_time_note = $BookingPress->bookingpress_get_customize_settings('date_time_step_note','booking_form');
$bookingpress_date_time_note = stripslashes_deep( $bookingpress_date_time_note );
$bookingpress_summary_content_note = $BookingPress->bookingpress_get_customize_settings('summary_step_note','booking_form');
$bookingpress_summary_content_note = stripslashes_deep( $bookingpress_summary_content_note );
?>

<div class="bpa-frontend-main-container" :class="bookingpress_container_dynamic_class" id="bookingpress_booking_form_<?php echo esc_html($bookingpress_uniq_id); ?>">
    <?php wp_nonce_field('bpa_wp_nonce'); ?>
    <div class="bpa-front-loader-container" v-if="is_booking_form_empty_loader == '1'">
        <div class="bpa-front-loader">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid meet" width="256" height="256" viewBox="0 0 256 256" style="width:100%;height:100%">
                <defs>
                    <animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_1_C_0_P_0" fill="freeze" attributeName="d" attributeType="XML" from="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z " to="M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z " keyTimes="0;0.5037594;0.5263158;0.5789474;0.6691729;0.6992481;0.7593985;0.7669173;1" values="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M303.49 386.7 C303.49,386.7 284.88,386.7 284.88,386.7 C284.88,386.7 284.88,402.72 284.88,402.72 C284.88,402.72 293.41,402.87 293.41,402.87 C293.41,402.87 293.07,405.24 293.07,405.24 C293.07,405.24 296.63,405.24 296.63,405.24 C296.63,405.24 296.82,402.57 296.82,402.57 C296.82,402.57 304.49,401.98 304.49,401.98 C304.49,401.98 303.49,386.7 303.49,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,398.12 265.56,398.12 C265.56,398.12 266.75,407.02 266.75,407.02 C266.75,407.02 294.78,405.83 294.78,405.83 C294.78,405.83 298.34,405.83 298.34,405.83 C298.34,405.83 332.75,406.72 332.75,406.72 C332.75,406.72 332.45,399.46 332.45,399.46 C332.45,399.46 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,442.32 265.56,442.32 C265.56,442.32 266.75,448.4 266.75,448.4 C266.75,448.4 283.8,447.51 283.8,447.51 C283.8,447.51 312.06,447.21 312.06,447.21 C312.06,447.21 332.75,448.1 332.75,448.1 C332.75,448.1 332.45,443.65 332.45,443.65 C332.45,443.65 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.86,453.14 265.86,453.14 C265.86,453.14 276.98,456.11 276.98,456.11 C276.98,456.11 277.28,447.51 277.28,447.51 C277.28,447.51 319.47,447.81 319.47,447.81 C319.47,447.81 318.81,456.11 318.81,456.11 C318.81,456.11 329.63,454.92 329.63,454.92 C329.63,454.92 330.97,386.7 330.97,386.7z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.63,448.83 295.63,448.83 C295.63,448.83 295.71,448.75 295.71,448.75 C295.71,448.75 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z " keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0" calcMode="spline"/>
                    <clipPath id="_R_G_L_1_C_0">
                        <path id="_R_G_L_1_C_0_P_0" fill-rule="nonzero"/>
                    </clipPath>
                    <animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_0_C_0_P_0" fill="freeze" attributeName="d" attributeType="XML" from="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z " to="M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z " keyTimes="0;0.1804511;0.2180451;0.2481203;0.2631579;0.2706767;0.2781955;0.2857143;0.3157895;0.3308271;0.3533835;0.3834586;0.406015;0.4135338;0.4210526;0.4511278;0.4736842;0.4887218;0.4962406;1" values="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M310.92 429.74 C310.92,429.74 310.97,429.75 310.97,429.75 C310.97,429.75 310.93,429.74 310.93,429.74 C310.93,429.74 310.91,429.77 310.91,429.77 C310.91,429.77 310.94,429.77 310.94,429.77 C310.94,429.77 310.99,429.77 310.99,429.77 C310.99,429.77 311.09,429.7 311.09,429.7 C311.09,429.7 310.99,429.73 310.99,429.73 C310.99,429.73 310.9,434.91 310.9,434.91 C310.9,434.91 312.25,433.8 312.25,433.8 C312.25,433.8 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 303.93,428.18 303.93,428.18 C303.93,428.18 303.66,428.14 303.66,428.14 C303.66,428.14 303.84,428.16 303.84,428.16 C303.84,428.16 303.52,428.11 303.52,428.11 C303.52,428.11 303.67,428.12 303.67,428.12 C303.67,428.12 303.58,428.1 303.58,428.1 C303.58,428.1 303.49,428.3 303.49,428.11 C303.49,427.93 303.63,428.09 303.63,428.09 C303.63,428.09 303.45,428.1 303.45,428.1 C303.45,428.1 303.76,428.04 303.76,428.04 C303.76,428.04 303.73,428 303.73,428 C303.73,428 303.69,427.98 303.69,427.98 C303.69,427.98 303.71,428.13 303.71,428.13 C303.71,428.13 303.76,428.08 303.76,428.08 C303.76,428.08 303.8,428.06 303.8,428.06 C303.8,428.06 303.8,428.11 303.8,428.11 C303.8,428.11 303.58,428.16 303.58,428.16 C303.58,428.16 310.92,429.75 310.92,429.75 C310.92,429.75 310.91,429.75 310.91,429.75 C310.91,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.9,429.75 310.9,429.75 C310.9,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.92,429.74 310.92,429.74z ;M299.65 434.12 C299.65,434.12 299.7,434.13 299.7,434.13 C299.7,434.13 299.66,434.11 299.66,434.11 C299.66,434.11 299.64,434.14 299.64,434.14 C299.64,434.14 299.66,434.14 299.66,434.14 C299.66,434.14 299.72,434.15 299.72,434.15 C299.72,434.15 299.81,434.08 299.81,434.08 C299.81,434.08 299.72,434.11 299.72,434.11 C299.72,434.11 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 300.06,430.31 300.06,430.31 C300.06,430.31 299.78,430.27 299.78,430.27 C299.78,430.27 299.96,430.29 299.96,430.29 C299.96,430.29 299.65,430.25 299.65,430.25 C299.65,430.25 299.8,430.25 299.8,430.25 C299.8,430.25 299.7,430.24 299.7,430.24 C299.7,430.24 299.61,430.43 299.61,430.25 C299.61,430.06 299.75,430.22 299.75,430.22 C299.75,430.22 299.57,430.23 299.57,430.23 C299.57,430.23 299.89,430.17 299.89,430.17 C299.89,430.17 299.85,430.13 299.85,430.13 C299.85,430.13 299.82,430.12 299.82,430.12 C299.82,430.12 299.83,430.26 299.83,430.26 C299.83,430.26 299.89,430.21 299.89,430.21 C299.89,430.21 299.93,430.19 299.93,430.19 C299.93,430.19 299.93,430.25 299.93,430.25 C299.93,430.25 299.7,430.29 299.7,430.29 C299.7,430.29 299.65,434.13 299.65,434.13 C299.65,434.13 299.64,434.13 299.64,434.13 C299.64,434.13 299.66,434.13 299.66,434.13 C299.66,434.13 299.63,434.13 299.63,434.13 C299.63,434.13 299.65,434.13 299.65,434.13 C299.65,434.13 299.65,434.12 299.65,434.12z ;M292.83 434.12 C292.83,434.12 292.81,434.11 292.81,434.11 C292.81,434.11 292.84,434.12 292.84,434.12 C292.84,434.12 292.82,434.15 292.82,434.15 C292.82,434.15 292.85,434.15 292.85,434.15 C292.85,434.15 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 292.89,430.31 292.89,430.31 C292.89,430.31 292.69,430.25 292.69,430.25 C292.69,430.25 292.72,430.28 292.72,430.28 C292.72,430.28 292.63,430.26 292.63,430.26 C292.63,430.26 292.65,430.43 292.65,430.25 C292.65,430.06 292.56,430.15 292.56,430.15 C292.56,430.15 292.61,430.23 292.61,430.23 C292.61,430.23 292.93,430.17 292.93,430.17 C292.93,430.17 292.89,430.13 292.89,430.13 C292.89,430.13 292.85,430.12 292.85,430.12 C292.85,430.12 292.87,430.26 292.87,430.26 C292.87,430.26 292.93,430.21 292.93,430.21 C292.93,430.21 292.96,430.19 292.96,430.19 C292.96,430.19 292.96,430.25 292.96,430.25 C292.96,430.25 292.77,430.22 292.77,430.22 C292.77,430.22 292.83,434.13 292.83,434.13 C292.83,434.13 292.82,434.13 292.82,434.13 C292.82,434.13 292.84,434.13 292.84,434.13 C292.84,434.13 292.81,434.13 292.81,434.13 C292.81,434.13 292.83,434.13 292.83,434.13 C292.83,434.13 292.83,434.12 292.83,434.12z ;M286.91 434.04 C286.91,434.04 286.89,434.02 286.89,434.02 C286.89,434.02 286.92,434.03 286.92,434.03 C286.92,434.03 286.9,434.06 286.9,434.06 C286.9,434.06 286.92,434.06 286.92,434.06 C286.92,434.06 294.61,434.08 294.61,434.08 C294.61,434.08 298.39,434.03 298.39,434.03 C298.39,434.03 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.91,428.68 291.91,428.68 C291.91,428.68 291.82,428.67 291.82,428.67 C291.82,428.67 291.88,428.65 291.88,428.46 C291.88,428.28 291.78,428.37 291.78,428.37 C291.78,428.37 291.84,428.44 291.84,428.44 C291.84,428.44 292.15,428.39 292.15,428.39 C292.15,428.39 292.12,428.35 292.12,428.35 C292.12,428.35 292.08,428.33 292.08,428.33 C292.08,428.33 292.1,428.48 292.1,428.48 C292.1,428.48 292.15,428.42 292.15,428.42 C292.15,428.42 292.19,428.41 292.19,428.41 C292.19,428.41 292.19,428.46 292.19,428.46 C292.19,428.46 291.97,428.51 291.97,428.51 C291.97,428.51 287.14,434.07 287.14,434.07 C287.14,434.07 286.89,434.05 286.89,434.05 C286.89,434.05 286.92,434.05 286.92,434.05 C286.92,434.05 286.89,434.05 286.89,434.05 C286.89,434.05 286.91,434.05 286.91,434.05 C286.91,434.05 286.91,434.04 286.91,434.04z ;M286.7 429.47 C286.7,429.47 286.88,429.37 286.88,429.37 C286.88,429.37 286.52,429.45 286.52,429.45 C286.52,429.45 286.83,429.85 286.83,429.85 C286.83,429.85 286.14,434.18 286.14,434.18 C286.14,434.18 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.08 298.37,434.08 C298.37,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.38,430.31 298.38,430.31 C298.38,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.99,426.42 291.99,426.42 C291.99,426.42 291.87,426.34 291.87,426.34 C291.87,426.34 292.01,426.25 292.01,426.07 C292.01,425.88 292.05,425.99 292.05,425.99 C292.05,425.99 291.97,425.95 291.97,425.95 C291.97,425.95 292.39,425.98 292.39,425.98 C292.39,425.98 292.27,426.05 292.27,426.05 C292.27,426.05 292.35,425.99 292.35,425.99 C292.35,425.99 292.32,426 292.32,426 C292.32,426 292.4,426 292.4,426 C292.4,426 292.4,426.06 292.4,426.06 C292.4,426.06 292.39,426.05 292.39,426.05 C292.39,426.05 292.62,426.45 292.62,426.45 C292.62,426.45 286.78,429.41 286.78,429.41 C286.78,429.41 286.55,429.2 286.55,429.2 C286.55,429.2 286.62,429.38 286.62,429.38 C286.62,429.38 286.51,429.44 286.51,429.44 C286.51,429.44 286.46,429.37 286.46,429.37 C286.46,429.37 286.7,429.47 286.7,429.47z ;M286.5 424.9 C286.5,424.9 286.87,424.72 286.87,424.72 C286.87,424.72 286.13,424.87 286.13,424.87 C286.13,424.87 286.76,425.64 286.76,425.64 C286.76,425.64 285.37,434.3 285.37,434.3 C285.37,434.3 294.63,434.09 294.63,434.09 C294.63,434.09 298.37,434.09 298.37,434.09 C298.37,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.36,430.31 298.36,430.31 C298.36,430.31 294.59,430.33 294.59,430.33 C294.59,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.06,424.16 292.06,424.16 C292.06,424.16 291.91,424.01 291.91,424.01 C291.91,424.01 292.13,423.86 292.13,423.68 C292.13,423.49 292.32,423.6 292.32,423.6 C292.32,423.6 292.1,423.46 292.1,423.46 C292.1,423.46 292.62,423.57 292.62,423.57 C292.62,423.57 292.43,423.75 292.43,423.75 C292.43,423.75 292.62,423.64 292.62,423.64 C292.62,423.64 292.54,423.53 292.54,423.53 C292.54,423.53 292.65,423.57 292.65,423.57 C292.65,423.57 292.62,423.72 292.62,423.72 C292.62,423.72 292.58,423.64 292.58,423.64 C292.58,423.64 293.27,424.39 293.27,424.39 C293.27,424.39 286.43,424.75 286.43,424.75 C286.43,424.75 286.2,424.35 286.2,424.35 C286.2,424.35 286.31,424.72 286.31,424.72 C286.31,424.72 286.13,424.83 286.13,424.83 C286.13,424.83 286.02,424.68 286.02,424.68 C286.02,424.68 286.5,424.9 286.5,424.9z ;M285.53 417.93 C285.53,417.93 285.61,418.01 285.61,418.01 C285.61,418.01 285.39,417.97 285.39,417.97 C285.39,417.97 285.68,418.12 285.68,418.12 C285.68,418.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.38,434.11 298.38,434.11 C298.38,434.11 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.71,430.31 298.71,430.31 C298.71,430.31 293.3,430.31 293.3,430.31 C293.3,430.31 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.26,417.75 291.26,417.56 C291.26,417.38 291.34,417.38 291.34,417.38 C291.34,417.38 291.45,417.54 291.45,417.54 C291.45,417.54 291.21,417.5 291.21,417.5 C291.21,417.5 291.32,417.45 291.32,417.45 C291.32,417.45 291.28,417.51 291.28,417.51 C291.28,417.51 291.5,417.56 291.5,417.56 C291.5,417.56 291.52,417.54 291.52,417.54 C291.52,417.54 291.45,417.6 291.45,417.6 C291.45,417.6 291.43,417.67 291.43,417.67 C291.43,417.67 291.41,417.89 291.41,417.89 C291.41,417.89 291.24,417.95 291.24,417.95 C291.24,417.95 285.98,417.86 285.98,417.86 C285.98,417.86 286.02,417.69 286.02,417.69 C286.02,417.69 285.92,417.77 285.92,417.77 C285.92,417.77 285.81,417.62 285.81,417.62 C285.81,417.62 285.53,417.93 285.53,417.93z ;M284.93 404.18 C284.93,404.18 281.14,411.97 281.14,411.97 C281.14,411.97 273.88,412.04 273.88,412.04 C273.88,412.04 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.08 298.36,434.08 C298.36,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.35,430.31 298.35,430.31 C298.35,430.31 294.59,430.32 294.59,430.32 C294.59,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 291.91,415.81 291.91,415.81 C291.91,415.81 291.8,415.82 291.8,415.82 C291.8,415.82 291.88,415.73 291.88,415.73 C291.88,415.73 291.9,415.66 291.9,415.66 C291.9,415.66 291.8,415.65 291.8,415.65 C291.8,415.65 291.73,415.73 291.73,415.73 C291.73,415.73 291.87,415.58 291.87,415.58 C291.87,415.58 291.87,415.71 291.87,415.71 C291.87,415.71 291.83,415.72 291.83,415.72 C291.83,415.72 291.82,415.71 291.82,415.71 C291.82,415.71 291.66,414.92 291.66,414.92 C291.66,414.92 291.45,413.38 291.45,413.38 C291.45,413.38 291.09,411.81 291.09,411.81 C291.09,411.81 291.05,411.77 291.05,411.77 C291.05,411.77 289.08,410.26 289.08,410.26 C289.08,410.26 284.93,404.18 284.93,404.18z ;M298.66 404.21 C298.66,404.21 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.76,430.32 298.76,430.32 C298.76,430.32 294.62,430.33 294.62,430.33 C294.62,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 300.75,413.19 300.75,413.19 C300.75,413.19 300.74,413.2 300.74,413.2 C300.74,413.2 300.68,413.28 300.68,413.28 C300.68,413.28 300.74,413.15 300.74,413.15 C300.74,413.15 300.76,413.19 300.76,413.19 C300.76,413.19 300.77,413.17 300.77,413.17 C300.77,413.17 303.55,406.44 303.55,406.44 C303.55,406.44 302.85,404.47 302.85,404.47 C302.85,404.47 301.29,403.47 301.29,403.47 C301.29,403.47 301.18,403.32 301.18,403.32 C301.18,403.32 298.66,404.21 298.66,404.21z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.07 294.61,434.07 C294.61,434.07 298.36,434.07 298.36,434.07 C298.36,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.73,430.31 298.73,430.31 C298.73,430.31 293.3,430.33 293.3,430.33 C293.3,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.59,416.02 302.59,416.02 C302.59,416.02 302.55,415.98 302.55,415.98 C302.55,415.98 302.63,415.99 302.63,415.99 C302.63,415.99 306.67,409.55 306.67,409.55 C306.67,409.55 306.65,409.61 306.65,409.61 C306.65,409.61 306.59,409.55 306.59,409.55 C306.59,409.55 306.69,409.72 306.69,409.72 C306.69,409.72 306.58,409.57 306.58,409.57 C306.58,409.57 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.29,420.1 306.29,420.1 C306.29,420.1 301.7,423.39 301.7,423.39 C301.7,423.39 298.38,430.31 298.38,430.31 C298.38,430.31 293.4,430.32 293.4,430.32 C293.4,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.63,417.02 302.63,417.02 C302.63,417.02 302.61,416.97 302.61,416.97 C302.61,416.97 302.63,416.9 302.63,416.9 C302.63,416.9 307.12,415.55 307.12,415.55 C307.12,415.55 307.51,415.47 307.51,415.47 C307.51,415.47 307.52,415.47 307.52,415.47 C307.52,415.47 309.01,412.56 309.01,412.56 C309.01,412.56 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.08 294.6,434.08 C294.6,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.05,420.2 306.05,420.2 C306.05,420.2 301.63,423.29 301.63,423.29 C301.63,423.29 298.57,430.33 298.57,430.33 C298.57,430.33 293.35,430.32 293.35,430.32 C293.35,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.72,417.16 306.72,417.16 C306.72,417.16 307.56,417.29 307.56,417.29 C307.56,417.29 307.59,417.33 307.59,417.33 C307.59,417.33 308.54,413.47 308.54,413.47 C308.54,413.47 306.71,408.22 306.71,408.22 C306.71,408.22 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.62,434.09 294.62,434.09 C294.62,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.8,420.3 305.8,420.3 C305.8,420.3 301.55,423.2 301.55,423.2 C301.55,423.2 298.74,430.31 298.74,430.31 C298.74,430.31 293.34,430.32 293.34,430.32 C293.34,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.32,418.77 306.32,418.77 C306.32,418.77 307.34,417.78 307.34,417.78 C307.34,417.78 307.74,418.52 307.74,418.52 C307.74,418.52 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.09 294.6,434.09 C294.6,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.98,420.3 305.98,420.3 C305.98,420.3 301.72,423.59 301.72,423.59 C301.72,423.59 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 296.68,421.72 296.68,421.72 C296.68,421.72 300.57,423.18 300.57,423.18 C300.57,423.18 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.41,419.97 306.41,419.97 C306.41,419.97 301.7,423.64 301.7,423.64 C301.7,423.64 298.69,430.31 298.69,430.31 C298.69,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 294.58,430.33 294.58,430.33 C294.58,430.33 298.38,430.31 298.38,430.31 C298.38,430.31 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.73,439.55 293.73,439.55 C293.73,439.55 298.46,439.54 298.46,439.54 C298.46,439.54 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.43,419.98 306.43,419.98 C306.43,419.98 301.75,423.57 301.75,423.57 C301.75,423.57 298.73,430.27 298.73,430.27 C298.73,430.27 293.72,430.3 293.72,430.3 C293.72,430.3 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.7,430.31 293.7,430.31 C293.7,430.31 298.74,430.26 298.74,430.26 C298.74,430.26 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z " keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0" calcMode="spline"/>
                    <clipPath id="_R_G_L_0_C_0">
                        <path id="_R_G_L_0_C_0_P_0" fill-rule="nonzero"/>
                    </clipPath>
                    <animate attributeType="XML" attributeName="opacity" dur="2s" from="0" to="1" xlink:href="#time_group"/>
                </defs>
                <g id="_R_G">
                    <g id="_R_G_L_1_G" transform=" translate(127.638, 127.945) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
                        <g clip-path="url(#_R_G_L_1_C_0)">
                            <path id="_R_G_L_1_G_G_0_D_0_P_0" class="bpa-front-loader-cl-primary" fill-opacity="1" fill-rule="nonzero" d=" M328 398.61 C328,398.61 328,446.23 328,446.23 C328,449.7 325.2,452.5 321.75,452.5 C321.75,452.5 274.25,452.5 274.25,452.5 C270.8,452.5 268,449.7 268,446.23 C268,446.23 268,398.61 268,398.61 C268,395.15 270.8,392.35 274.25,392.35 C274.25,392.35 283.46,392.26 283.46,392.26 C283.46,392.26 283.46,390.38 283.46,390.38 C283.46,389.76 284.08,388.5 285.33,388.5 C286.58,388.5 287.21,389.75 287.21,390.38 C287.21,390.38 287.21,397.89 287.21,397.89 C287.21,398.53 286.59,399.78 285.33,399.78 C284.08,399.78 283.46,398.53 283.46,397.9 C283.46,397.9 283.46,396.02 283.46,396.02 C283.46,396.02 275.5,396.1 275.5,396.1 C273.43,396.1 271.75,397.79 271.75,399.86 C271.75,399.86 271.75,444.98 271.75,444.98 C271.75,447.06 273.43,448.74 275.5,448.74 C275.5,448.74 320.5,448.74 320.5,448.74 C322.57,448.74 324.25,447.06 324.25,444.98 C324.25,444.98 324.25,399.86 324.25,399.86 C324.25,397.79 322.57,396.1 320.5,396.1 C320.5,396.1 312.62,396.1 312.62,396.1 C312.62,396.1 312.63,397.06 312.63,397.99 C312.63,398.61 312,399.86 310.75,399.86 C309.5,399.86 308.88,398.61 308.88,397.98 C308.88,397.98 308.87,396.1 308.87,396.1 C308.87,396.1 301.88,396.1 301.88,396.1 C300.84,396.1 300,395.26 300,394.23 C300,393.19 300.84,392.35 301.88,392.35 C301.88,392.35 308.87,392.35 308.87,392.35 C308.87,392.35 308.87,390.47 308.87,390.47 C308.87,389.83 309.5,388.5 310.75,388.5 C312,388.5 312.62,389.84 312.62,390.47 C312.62,390.47 312.62,392.35 312.62,392.35 C312.62,392.35 321.75,392.35 321.75,392.35 C325.2,392.35 328,395.15 328,398.61z "/>
                        </g>
                    </g>
                    <g id="_R_G_L_0_G" transform=" translate(125.555, 126.412) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
                        <g clip-path="url(#_R_G_L_0_C_0)">
                            <path id="_R_G_L_0_G_G_0_D_0_P_0" class="bpa-front-loader-cl-primary" fill-opacity="1" fill-rule="nonzero" d=" M305.86 420.29 C305.86,420.29 307.11,419.04 307.11,415.28 C307.11,409.01 303.36,407.76 298.36,407.76 C298.36,407.76 287.11,407.76 287.11,407.76 C287.11,407.76 287.11,434.08 287.11,434.08 C287.11,434.08 294.61,434.08 294.61,434.08 C294.61,434.08 294.61,441.6 294.61,441.6 C294.61,441.6 298.36,441.6 298.36,441.6 C298.36,441.6 298.36,434.08 298.36,434.08 C302.71,434.08 305.73,434.08 307.98,431.3 C309.07,429.95 309.62,428.24 309.61,426.5 C309.61,425.58 309.51,424.67 309.3,424.05 C308.73,422.65 308.36,421.55 305.86,420.29z  M302.11 430.32 C302.11,430.32 298.36,430.32 298.36,430.32 C298.36,430.32 298.36,426.56 298.36,426.56 C298.36,424.48 300.03,422.8 302.11,422.8 C304.13,422.8 305.86,424.43 305.86,426.56 C305.86,428.78 304.03,430.32 302.11,430.32z  M299.07 419.95 C298.43,420.26 297.82,420.63 297.26,421.05 C295.87,422.1 294.61,423.58 294.61,426.56 C294.61,426.56 294.61,430.32 294.61,430.32 C294.61,430.32 290.86,430.32 290.86,430.32 C290.86,430.32 290.86,411.52 290.86,411.52 C290.86,411.52 298.36,411.52 298.36,411.52 C301.35,411.52 303.36,412.77 303.36,415.28 C303.36,417.58 301.65,418.68 299.07,419.95z "/>
                        </g>
                    </g>
                </g>
                <g id="time_group"/>
            </svg>
        </div>
    </div>
    <div id="bpa-front-tabs" class="bpa-front-tabs bpa-front-tabs--vertical-left <?php echo ( $bookingpress_tabs_position == 'left' ) ? 'bpa-front-tabs--left' : '--bpa-top'; ?>" v-if="(service_categories != '' || is_uncategorize_service_added == '1') && is_booking_form_empty_loader == '0' && bookingpress_display_no_service_placeholder == false ">
        <div class="bpa-front-tab-menu">
            <a href="javascript:void(0)" class="bpa-front-tab-menu--item" :class="[ ( (bookingpress_current_tab == sidebar_steps.tab_value) ? ' __bpa-is-active' : ''), ( (sidebar_steps.is_allow_navigate == 0) ? 'bpa-front-disabled-menu-item' : '' ) ]" v-for="(sidebar_steps, index) in bookingpress_sidebar_step_data" @click="bookingpress_step_navigation(sidebar_steps.tab_value, sidebar_steps.next_tab_name, sidebar_steps.previous_tab_name)" v-if="sidebar_steps.is_display_step == 1 || 'undefined' == typeof sidebar_steps.is_display_step" >
            	<span class="bpa-front-tm--item-icon material-icons-round" v-html="sidebar_steps.tab_icon"></span>
                <div class="bpa-front-tm--item-label">{{sidebar_steps.tab_name}}</div>
            </a>
        </div><!--end of tab-menu-->

        <div class="bpa-front-tabs--panel-body" :class="[bookingpress_current_tab == 'service' ? ' __bpa-is-active' : '']" v-if="hide_category_service != '1'">
            <div class="bpa-front-default-card">
                <div class="bpa-front-toast-notification --bpa-error" v-if="is_display_error == '1'">
                    <div class="bpa-front-tn-body">                        
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 7c.55 0 1 .45 1 1v4c0 .55-.45 1-1 1s-1-.45-1-1V8c0-.55.45-1 1-1zm-.01-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm1-3h-2v-2h2v2z"/></svg>
                        <p>{{ is_error_msg }}</p>
                    </div>
                </div>
                <div class="bpa-front-dc--body">
                    <el-row v-if="false == hide_category_selection">
                        <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                            <div class="bpa-front-module-container bpa-front-module--category">
                                <el-row>
                                    <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                                        <div class="bpa-front-module-heading"><?php echo esc_html($bookingpress_category_title); ?></div>
                                    </el-col>
                                </el-row>
                                <el-row>
                                    <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                                        <div class="bpa-front-cat-items-wrapper">
                                            <div class="bpa-front-cat-items">
                                                <el-tag class="bpa-front-ci-pill" :class="((appointment_step_form_data.selected_category == cat_data.category_id) ? '__bpa-is-active' : '')" v-for="cat_data in bookingpress_all_categories" v-if="'undefined' == typeof cat_data.is_visible || cat_data.is_visible == true" @click="bpa_select_category( cat_data.category_id, cat_data.category_name, cat_data.total_services )">
                                                    <div class="bpa-front-ci-item-title">{{cat_data.category_name}}</div>
                                                    <svg v-if="appointment_step_form_data.selected_category == cat_data.category_id" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM9.29 16.29 5.7 12.7c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L10 14.17l6.88-6.88c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-7.59 7.59c-.38.39-1.02.39-1.41 0z"/></svg>
                                                </el-tag>
                                            </div>
                                        </div>
                                    </el-col>
                                </el-row>
                            </div>
                        </el-col>
                    </el-row>
                    <el-row>
                        <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                            <div class="bpa-front-module-container bpa-front-module--service">
                                <el-row>
                                    <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                                        <div class="bpa-front-module-heading"><?php echo esc_html($bookingpress_services_title); ?></div>
                                    </el-col>
                                </el-row>
                                <div class="bpa-front-module--service-items-row">
                                    <div class="bpa-fm--si--col" v-if="(typeof isLoadClass != 'undefined' && isLoadClass == 1 ) && service_details.is_visible == true" v-for="service_details in bpasortedServices">
                                        <div class="bpa-front-module--service-item" :class="[(appointment_step_form_data.selected_service == service_details.bookingpress_service_id) ? '__bpa-is-selected' : '', (display_service_description == 1 && service_details.bookingpress_service_description != '') ? '__bpa-is-description-enable' : '']" @click="selectDate(service_details.bookingpress_service_id, service_details.bookingpress_service_name, service_details.bookingpress_service_price, service_details.service_price_without_currency, 'true')">
                                        <div class="bpa-front-si-card">
                                            <div class="bpa-front-si-card--checkmark-icon" v-if="appointment_step_form_data.selected_service == service_details.bookingpress_service_id">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM9.29 16.29 5.7 12.7c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L10 14.17l6.88-6.88c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-7.59 7.59c-.38.39-1.02.39-1.41 0z"/></svg>
                                            </div>
                                            <div class="bpa-front-si-card__left" v-if="('undefined' == typeof service_details.use_placeholder || false == service_details.use_placeholder)">
                                                <img :src="service_details.img_url" alt="">
                                            </div>
                                            <div class="bpa-front-si-card__left" v-else>
                                                <div class="bpa-front-si__default-img">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M13.2 7.07L10.25 11l2.25 3c.33.44.24 1.07-.2 1.4-.44.33-1.07.25-1.4-.2-1.05-1.4-2.31-3.07-3.1-4.14-.4-.53-1.2-.53-1.6 0l-4 5.33c-.49.67-.02 1.61.8 1.61h18c.82 0 1.29-.94.8-1.6l-7-9.33c-.4-.54-1.2-.54-1.6 0z"/></svg>
                                                </div>
                                            </div>
                                            <div class="bpa-front-si__card-body">
                                                <div class="bpa-front-si__card-body--heading">{{ service_details.bookingpress_service_name }}</div>
                                                <p v-html="service_details.bookingpress_service_description" class="--bpa-is-desc" v-if="display_service_description == 1 && service_details.bookingpress_service_description != ''"> </p> 
                                                <div class="bpa-front-si-cb__specs">
                                                    <div class="bpa-front-si-cb__specs-item">
                                                        
                                                        <p><?php echo wp_kses($bookingpress_service_duration_text, $bookingpress_allow_tag); ?> <strong>{{ service_details.bookingpress_service_duration_val }} {{ service_details.bookingpress_service_duration_label }}</strong></p>
                                                    </div>
                                                    <div class="bpa-front-si-cb__specs-item" v-if="service_details.service_price_without_currency != 0">
                                                        <p><?php echo wp_kses($bookingpress_service_price_text, $bookingpress_allow_tag); ?> <strong class="--is-service-price">{{ service_details.bookingpress_service_price }}</strong></p>                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </el-col>
                    </el-row>
                </div>
                <div class="bpa-front-dc--footer" :class="bookingpress_footer_dynamic_class">
                    <el-row>
                        <el-col>
                            <div class="bpa-front-tabs--foot">                                
                                <el-button class="bpa-front-btn bpa-front-btn__medium bpa-front-btn--primary" @click="bookingpress_step_navigation(bookingpress_sidebar_step_data['service'].next_tab_name, bookingpress_sidebar_step_data['service'].next_tab_name, bookingpress_sidebar_step_data['service'].previous_tab_name)">
									<?php echo esc_html( $bookingpress_next_btn_text ); ?>&nbsp;<strong class="">{{ bookingpress_sidebar_step_data[bookingpress_sidebar_step_data[bookingpress_current_tab].next_tab_name].tab_name }}</strong>                                    
                                    <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24"><rect fill="none" height="24" width="24"/><path d="M14.29,5.71L14.29,5.71c-0.39,0.39-0.39,1.02,0,1.41L18.17,11H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h15.18l-3.88,3.88 c-0.39,0.39-0.39,1.02,0,1.41l0,0c0.39,0.39,1.02,0.39,1.41,0l5.59-5.59c0.39-0.39,0.39-1.02,0-1.41L15.7,5.71 C15.32,5.32,14.68,5.32,14.29,5.71z"/></svg>
                                </el-button>
                            </div>
                        </el-col>
                    </el-row>
                </div>
            </div>
        </div><!--end of tab one-->

        <div class="bpa-front-tabs--panel-body" :class="[bookingpress_current_tab == 'datetime' ? ' __bpa-is-active' : '']">
            <div class="bpa-front-default-card">    
                <div class="bpa-front-toast-notification --bpa-error" v-if="is_display_error == '1'">
                    <div class="bpa-front-tn-body">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 7c.55 0 1 .45 1 1v4c0 .55-.45 1-1 1s-1-.45-1-1V8c0-.55.45-1 1-1zm-.01-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm1-3h-2v-2h2v2z"/></svg>
                        <p>{{ is_error_msg }}</p>
                    </div>
                </div>            
                <div class="bpa-front-dc--body">
                    <el-row>
                        <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                            <div class="bpa-front-module-container bpa-front-module--date-and-time">
                                <div class="bpa-full-container-loader" v-if="isLoadDateTimeCalendarLoad == '1'">
									<div class="bpa-front-loader-container">
										<div class="bpa-front-loader">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid meet" width="256" height="256" viewBox="0 0 256 256" style="width:100%;height:100%">
                                                <defs>
                                                    <animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_1_C_0_P_0" fill="freeze" attributeName="d" attributeType="XML" from="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z " to="M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z " keyTimes="0;0.5037594;0.5263158;0.5789474;0.6691729;0.6992481;0.7593985;0.7669173;1" values="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M303.49 386.7 C303.49,386.7 284.88,386.7 284.88,386.7 C284.88,386.7 284.88,402.72 284.88,402.72 C284.88,402.72 293.41,402.87 293.41,402.87 C293.41,402.87 293.07,405.24 293.07,405.24 C293.07,405.24 296.63,405.24 296.63,405.24 C296.63,405.24 296.82,402.57 296.82,402.57 C296.82,402.57 304.49,401.98 304.49,401.98 C304.49,401.98 303.49,386.7 303.49,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,398.12 265.56,398.12 C265.56,398.12 266.75,407.02 266.75,407.02 C266.75,407.02 294.78,405.83 294.78,405.83 C294.78,405.83 298.34,405.83 298.34,405.83 C298.34,405.83 332.75,406.72 332.75,406.72 C332.75,406.72 332.45,399.46 332.45,399.46 C332.45,399.46 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,442.32 265.56,442.32 C265.56,442.32 266.75,448.4 266.75,448.4 C266.75,448.4 283.8,447.51 283.8,447.51 C283.8,447.51 312.06,447.21 312.06,447.21 C312.06,447.21 332.75,448.1 332.75,448.1 C332.75,448.1 332.45,443.65 332.45,443.65 C332.45,443.65 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.86,453.14 265.86,453.14 C265.86,453.14 276.98,456.11 276.98,456.11 C276.98,456.11 277.28,447.51 277.28,447.51 C277.28,447.51 319.47,447.81 319.47,447.81 C319.47,447.81 318.81,456.11 318.81,456.11 C318.81,456.11 329.63,454.92 329.63,454.92 C329.63,454.92 330.97,386.7 330.97,386.7z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.63,448.83 295.63,448.83 C295.63,448.83 295.71,448.75 295.71,448.75 C295.71,448.75 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z " keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0" calcMode="spline"/>
                                                    <clipPath id="_R_G_L_1_C_0">
                                                        <path id="_R_G_L_1_C_0_P_0" fill-rule="nonzero"/>
                                                    </clipPath>
                                                    <animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_0_C_0_P_0" fill="freeze" attributeName="d" attributeType="XML" from="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z " to="M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z " keyTimes="0;0.1804511;0.2180451;0.2481203;0.2631579;0.2706767;0.2781955;0.2857143;0.3157895;0.3308271;0.3533835;0.3834586;0.406015;0.4135338;0.4210526;0.4511278;0.4736842;0.4887218;0.4962406;1" values="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M310.92 429.74 C310.92,429.74 310.97,429.75 310.97,429.75 C310.97,429.75 310.93,429.74 310.93,429.74 C310.93,429.74 310.91,429.77 310.91,429.77 C310.91,429.77 310.94,429.77 310.94,429.77 C310.94,429.77 310.99,429.77 310.99,429.77 C310.99,429.77 311.09,429.7 311.09,429.7 C311.09,429.7 310.99,429.73 310.99,429.73 C310.99,429.73 310.9,434.91 310.9,434.91 C310.9,434.91 312.25,433.8 312.25,433.8 C312.25,433.8 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 303.93,428.18 303.93,428.18 C303.93,428.18 303.66,428.14 303.66,428.14 C303.66,428.14 303.84,428.16 303.84,428.16 C303.84,428.16 303.52,428.11 303.52,428.11 C303.52,428.11 303.67,428.12 303.67,428.12 C303.67,428.12 303.58,428.1 303.58,428.1 C303.58,428.1 303.49,428.3 303.49,428.11 C303.49,427.93 303.63,428.09 303.63,428.09 C303.63,428.09 303.45,428.1 303.45,428.1 C303.45,428.1 303.76,428.04 303.76,428.04 C303.76,428.04 303.73,428 303.73,428 C303.73,428 303.69,427.98 303.69,427.98 C303.69,427.98 303.71,428.13 303.71,428.13 C303.71,428.13 303.76,428.08 303.76,428.08 C303.76,428.08 303.8,428.06 303.8,428.06 C303.8,428.06 303.8,428.11 303.8,428.11 C303.8,428.11 303.58,428.16 303.58,428.16 C303.58,428.16 310.92,429.75 310.92,429.75 C310.92,429.75 310.91,429.75 310.91,429.75 C310.91,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.9,429.75 310.9,429.75 C310.9,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.92,429.74 310.92,429.74z ;M299.65 434.12 C299.65,434.12 299.7,434.13 299.7,434.13 C299.7,434.13 299.66,434.11 299.66,434.11 C299.66,434.11 299.64,434.14 299.64,434.14 C299.64,434.14 299.66,434.14 299.66,434.14 C299.66,434.14 299.72,434.15 299.72,434.15 C299.72,434.15 299.81,434.08 299.81,434.08 C299.81,434.08 299.72,434.11 299.72,434.11 C299.72,434.11 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 300.06,430.31 300.06,430.31 C300.06,430.31 299.78,430.27 299.78,430.27 C299.78,430.27 299.96,430.29 299.96,430.29 C299.96,430.29 299.65,430.25 299.65,430.25 C299.65,430.25 299.8,430.25 299.8,430.25 C299.8,430.25 299.7,430.24 299.7,430.24 C299.7,430.24 299.61,430.43 299.61,430.25 C299.61,430.06 299.75,430.22 299.75,430.22 C299.75,430.22 299.57,430.23 299.57,430.23 C299.57,430.23 299.89,430.17 299.89,430.17 C299.89,430.17 299.85,430.13 299.85,430.13 C299.85,430.13 299.82,430.12 299.82,430.12 C299.82,430.12 299.83,430.26 299.83,430.26 C299.83,430.26 299.89,430.21 299.89,430.21 C299.89,430.21 299.93,430.19 299.93,430.19 C299.93,430.19 299.93,430.25 299.93,430.25 C299.93,430.25 299.7,430.29 299.7,430.29 C299.7,430.29 299.65,434.13 299.65,434.13 C299.65,434.13 299.64,434.13 299.64,434.13 C299.64,434.13 299.66,434.13 299.66,434.13 C299.66,434.13 299.63,434.13 299.63,434.13 C299.63,434.13 299.65,434.13 299.65,434.13 C299.65,434.13 299.65,434.12 299.65,434.12z ;M292.83 434.12 C292.83,434.12 292.81,434.11 292.81,434.11 C292.81,434.11 292.84,434.12 292.84,434.12 C292.84,434.12 292.82,434.15 292.82,434.15 C292.82,434.15 292.85,434.15 292.85,434.15 C292.85,434.15 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 292.89,430.31 292.89,430.31 C292.89,430.31 292.69,430.25 292.69,430.25 C292.69,430.25 292.72,430.28 292.72,430.28 C292.72,430.28 292.63,430.26 292.63,430.26 C292.63,430.26 292.65,430.43 292.65,430.25 C292.65,430.06 292.56,430.15 292.56,430.15 C292.56,430.15 292.61,430.23 292.61,430.23 C292.61,430.23 292.93,430.17 292.93,430.17 C292.93,430.17 292.89,430.13 292.89,430.13 C292.89,430.13 292.85,430.12 292.85,430.12 C292.85,430.12 292.87,430.26 292.87,430.26 C292.87,430.26 292.93,430.21 292.93,430.21 C292.93,430.21 292.96,430.19 292.96,430.19 C292.96,430.19 292.96,430.25 292.96,430.25 C292.96,430.25 292.77,430.22 292.77,430.22 C292.77,430.22 292.83,434.13 292.83,434.13 C292.83,434.13 292.82,434.13 292.82,434.13 C292.82,434.13 292.84,434.13 292.84,434.13 C292.84,434.13 292.81,434.13 292.81,434.13 C292.81,434.13 292.83,434.13 292.83,434.13 C292.83,434.13 292.83,434.12 292.83,434.12z ;M286.91 434.04 C286.91,434.04 286.89,434.02 286.89,434.02 C286.89,434.02 286.92,434.03 286.92,434.03 C286.92,434.03 286.9,434.06 286.9,434.06 C286.9,434.06 286.92,434.06 286.92,434.06 C286.92,434.06 294.61,434.08 294.61,434.08 C294.61,434.08 298.39,434.03 298.39,434.03 C298.39,434.03 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.91,428.68 291.91,428.68 C291.91,428.68 291.82,428.67 291.82,428.67 C291.82,428.67 291.88,428.65 291.88,428.46 C291.88,428.28 291.78,428.37 291.78,428.37 C291.78,428.37 291.84,428.44 291.84,428.44 C291.84,428.44 292.15,428.39 292.15,428.39 C292.15,428.39 292.12,428.35 292.12,428.35 C292.12,428.35 292.08,428.33 292.08,428.33 C292.08,428.33 292.1,428.48 292.1,428.48 C292.1,428.48 292.15,428.42 292.15,428.42 C292.15,428.42 292.19,428.41 292.19,428.41 C292.19,428.41 292.19,428.46 292.19,428.46 C292.19,428.46 291.97,428.51 291.97,428.51 C291.97,428.51 287.14,434.07 287.14,434.07 C287.14,434.07 286.89,434.05 286.89,434.05 C286.89,434.05 286.92,434.05 286.92,434.05 C286.92,434.05 286.89,434.05 286.89,434.05 C286.89,434.05 286.91,434.05 286.91,434.05 C286.91,434.05 286.91,434.04 286.91,434.04z ;M286.7 429.47 C286.7,429.47 286.88,429.37 286.88,429.37 C286.88,429.37 286.52,429.45 286.52,429.45 C286.52,429.45 286.83,429.85 286.83,429.85 C286.83,429.85 286.14,434.18 286.14,434.18 C286.14,434.18 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.08 298.37,434.08 C298.37,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.38,430.31 298.38,430.31 C298.38,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.99,426.42 291.99,426.42 C291.99,426.42 291.87,426.34 291.87,426.34 C291.87,426.34 292.01,426.25 292.01,426.07 C292.01,425.88 292.05,425.99 292.05,425.99 C292.05,425.99 291.97,425.95 291.97,425.95 C291.97,425.95 292.39,425.98 292.39,425.98 C292.39,425.98 292.27,426.05 292.27,426.05 C292.27,426.05 292.35,425.99 292.35,425.99 C292.35,425.99 292.32,426 292.32,426 C292.32,426 292.4,426 292.4,426 C292.4,426 292.4,426.06 292.4,426.06 C292.4,426.06 292.39,426.05 292.39,426.05 C292.39,426.05 292.62,426.45 292.62,426.45 C292.62,426.45 286.78,429.41 286.78,429.41 C286.78,429.41 286.55,429.2 286.55,429.2 C286.55,429.2 286.62,429.38 286.62,429.38 C286.62,429.38 286.51,429.44 286.51,429.44 C286.51,429.44 286.46,429.37 286.46,429.37 C286.46,429.37 286.7,429.47 286.7,429.47z ;M286.5 424.9 C286.5,424.9 286.87,424.72 286.87,424.72 C286.87,424.72 286.13,424.87 286.13,424.87 C286.13,424.87 286.76,425.64 286.76,425.64 C286.76,425.64 285.37,434.3 285.37,434.3 C285.37,434.3 294.63,434.09 294.63,434.09 C294.63,434.09 298.37,434.09 298.37,434.09 C298.37,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.36,430.31 298.36,430.31 C298.36,430.31 294.59,430.33 294.59,430.33 C294.59,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.06,424.16 292.06,424.16 C292.06,424.16 291.91,424.01 291.91,424.01 C291.91,424.01 292.13,423.86 292.13,423.68 C292.13,423.49 292.32,423.6 292.32,423.6 C292.32,423.6 292.1,423.46 292.1,423.46 C292.1,423.46 292.62,423.57 292.62,423.57 C292.62,423.57 292.43,423.75 292.43,423.75 C292.43,423.75 292.62,423.64 292.62,423.64 C292.62,423.64 292.54,423.53 292.54,423.53 C292.54,423.53 292.65,423.57 292.65,423.57 C292.65,423.57 292.62,423.72 292.62,423.72 C292.62,423.72 292.58,423.64 292.58,423.64 C292.58,423.64 293.27,424.39 293.27,424.39 C293.27,424.39 286.43,424.75 286.43,424.75 C286.43,424.75 286.2,424.35 286.2,424.35 C286.2,424.35 286.31,424.72 286.31,424.72 C286.31,424.72 286.13,424.83 286.13,424.83 C286.13,424.83 286.02,424.68 286.02,424.68 C286.02,424.68 286.5,424.9 286.5,424.9z ;M285.53 417.93 C285.53,417.93 285.61,418.01 285.61,418.01 C285.61,418.01 285.39,417.97 285.39,417.97 C285.39,417.97 285.68,418.12 285.68,418.12 C285.68,418.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.38,434.11 298.38,434.11 C298.38,434.11 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.71,430.31 298.71,430.31 C298.71,430.31 293.3,430.31 293.3,430.31 C293.3,430.31 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.26,417.75 291.26,417.56 C291.26,417.38 291.34,417.38 291.34,417.38 C291.34,417.38 291.45,417.54 291.45,417.54 C291.45,417.54 291.21,417.5 291.21,417.5 C291.21,417.5 291.32,417.45 291.32,417.45 C291.32,417.45 291.28,417.51 291.28,417.51 C291.28,417.51 291.5,417.56 291.5,417.56 C291.5,417.56 291.52,417.54 291.52,417.54 C291.52,417.54 291.45,417.6 291.45,417.6 C291.45,417.6 291.43,417.67 291.43,417.67 C291.43,417.67 291.41,417.89 291.41,417.89 C291.41,417.89 291.24,417.95 291.24,417.95 C291.24,417.95 285.98,417.86 285.98,417.86 C285.98,417.86 286.02,417.69 286.02,417.69 C286.02,417.69 285.92,417.77 285.92,417.77 C285.92,417.77 285.81,417.62 285.81,417.62 C285.81,417.62 285.53,417.93 285.53,417.93z ;M284.93 404.18 C284.93,404.18 281.14,411.97 281.14,411.97 C281.14,411.97 273.88,412.04 273.88,412.04 C273.88,412.04 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.08 298.36,434.08 C298.36,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.35,430.31 298.35,430.31 C298.35,430.31 294.59,430.32 294.59,430.32 C294.59,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 291.91,415.81 291.91,415.81 C291.91,415.81 291.8,415.82 291.8,415.82 C291.8,415.82 291.88,415.73 291.88,415.73 C291.88,415.73 291.9,415.66 291.9,415.66 C291.9,415.66 291.8,415.65 291.8,415.65 C291.8,415.65 291.73,415.73 291.73,415.73 C291.73,415.73 291.87,415.58 291.87,415.58 C291.87,415.58 291.87,415.71 291.87,415.71 C291.87,415.71 291.83,415.72 291.83,415.72 C291.83,415.72 291.82,415.71 291.82,415.71 C291.82,415.71 291.66,414.92 291.66,414.92 C291.66,414.92 291.45,413.38 291.45,413.38 C291.45,413.38 291.09,411.81 291.09,411.81 C291.09,411.81 291.05,411.77 291.05,411.77 C291.05,411.77 289.08,410.26 289.08,410.26 C289.08,410.26 284.93,404.18 284.93,404.18z ;M298.66 404.21 C298.66,404.21 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.76,430.32 298.76,430.32 C298.76,430.32 294.62,430.33 294.62,430.33 C294.62,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 300.75,413.19 300.75,413.19 C300.75,413.19 300.74,413.2 300.74,413.2 C300.74,413.2 300.68,413.28 300.68,413.28 C300.68,413.28 300.74,413.15 300.74,413.15 C300.74,413.15 300.76,413.19 300.76,413.19 C300.76,413.19 300.77,413.17 300.77,413.17 C300.77,413.17 303.55,406.44 303.55,406.44 C303.55,406.44 302.85,404.47 302.85,404.47 C302.85,404.47 301.29,403.47 301.29,403.47 C301.29,403.47 301.18,403.32 301.18,403.32 C301.18,403.32 298.66,404.21 298.66,404.21z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.07 294.61,434.07 C294.61,434.07 298.36,434.07 298.36,434.07 C298.36,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.73,430.31 298.73,430.31 C298.73,430.31 293.3,430.33 293.3,430.33 C293.3,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.59,416.02 302.59,416.02 C302.59,416.02 302.55,415.98 302.55,415.98 C302.55,415.98 302.63,415.99 302.63,415.99 C302.63,415.99 306.67,409.55 306.67,409.55 C306.67,409.55 306.65,409.61 306.65,409.61 C306.65,409.61 306.59,409.55 306.59,409.55 C306.59,409.55 306.69,409.72 306.69,409.72 C306.69,409.72 306.58,409.57 306.58,409.57 C306.58,409.57 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.29,420.1 306.29,420.1 C306.29,420.1 301.7,423.39 301.7,423.39 C301.7,423.39 298.38,430.31 298.38,430.31 C298.38,430.31 293.4,430.32 293.4,430.32 C293.4,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.63,417.02 302.63,417.02 C302.63,417.02 302.61,416.97 302.61,416.97 C302.61,416.97 302.63,416.9 302.63,416.9 C302.63,416.9 307.12,415.55 307.12,415.55 C307.12,415.55 307.51,415.47 307.51,415.47 C307.51,415.47 307.52,415.47 307.52,415.47 C307.52,415.47 309.01,412.56 309.01,412.56 C309.01,412.56 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.08 294.6,434.08 C294.6,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.05,420.2 306.05,420.2 C306.05,420.2 301.63,423.29 301.63,423.29 C301.63,423.29 298.57,430.33 298.57,430.33 C298.57,430.33 293.35,430.32 293.35,430.32 C293.35,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.72,417.16 306.72,417.16 C306.72,417.16 307.56,417.29 307.56,417.29 C307.56,417.29 307.59,417.33 307.59,417.33 C307.59,417.33 308.54,413.47 308.54,413.47 C308.54,413.47 306.71,408.22 306.71,408.22 C306.71,408.22 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.62,434.09 294.62,434.09 C294.62,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.8,420.3 305.8,420.3 C305.8,420.3 301.55,423.2 301.55,423.2 C301.55,423.2 298.74,430.31 298.74,430.31 C298.74,430.31 293.34,430.32 293.34,430.32 C293.34,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.32,418.77 306.32,418.77 C306.32,418.77 307.34,417.78 307.34,417.78 C307.34,417.78 307.74,418.52 307.74,418.52 C307.74,418.52 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.09 294.6,434.09 C294.6,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.98,420.3 305.98,420.3 C305.98,420.3 301.72,423.59 301.72,423.59 C301.72,423.59 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 296.68,421.72 296.68,421.72 C296.68,421.72 300.57,423.18 300.57,423.18 C300.57,423.18 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.41,419.97 306.41,419.97 C306.41,419.97 301.7,423.64 301.7,423.64 C301.7,423.64 298.69,430.31 298.69,430.31 C298.69,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 294.58,430.33 294.58,430.33 C294.58,430.33 298.38,430.31 298.38,430.31 C298.38,430.31 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.73,439.55 293.73,439.55 C293.73,439.55 298.46,439.54 298.46,439.54 C298.46,439.54 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.43,419.98 306.43,419.98 C306.43,419.98 301.75,423.57 301.75,423.57 C301.75,423.57 298.73,430.27 298.73,430.27 C298.73,430.27 293.72,430.3 293.72,430.3 C293.72,430.3 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.7,430.31 293.7,430.31 C293.7,430.31 298.74,430.26 298.74,430.26 C298.74,430.26 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z " keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0" calcMode="spline"/>
                                                    <clipPath id="_R_G_L_0_C_0">
                                                        <path id="_R_G_L_0_C_0_P_0" fill-rule="nonzero"/>
                                                    </clipPath>
                                                    <animate attributeType="XML" attributeName="opacity" dur="2s" from="0" to="1" xlink:href="#time_group"/>
                                                </defs>
                                                <g id="_R_G">
                                                    <g id="_R_G_L_1_G" transform=" translate(127.638, 127.945) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
                                                        <g clip-path="url(#_R_G_L_1_C_0)">
                                                            <path id="_R_G_L_1_G_G_0_D_0_P_0" class="bpa-front-loader-cl-primary" fill-opacity="1" fill-rule="nonzero" d=" M328 398.61 C328,398.61 328,446.23 328,446.23 C328,449.7 325.2,452.5 321.75,452.5 C321.75,452.5 274.25,452.5 274.25,452.5 C270.8,452.5 268,449.7 268,446.23 C268,446.23 268,398.61 268,398.61 C268,395.15 270.8,392.35 274.25,392.35 C274.25,392.35 283.46,392.26 283.46,392.26 C283.46,392.26 283.46,390.38 283.46,390.38 C283.46,389.76 284.08,388.5 285.33,388.5 C286.58,388.5 287.21,389.75 287.21,390.38 C287.21,390.38 287.21,397.89 287.21,397.89 C287.21,398.53 286.59,399.78 285.33,399.78 C284.08,399.78 283.46,398.53 283.46,397.9 C283.46,397.9 283.46,396.02 283.46,396.02 C283.46,396.02 275.5,396.1 275.5,396.1 C273.43,396.1 271.75,397.79 271.75,399.86 C271.75,399.86 271.75,444.98 271.75,444.98 C271.75,447.06 273.43,448.74 275.5,448.74 C275.5,448.74 320.5,448.74 320.5,448.74 C322.57,448.74 324.25,447.06 324.25,444.98 C324.25,444.98 324.25,399.86 324.25,399.86 C324.25,397.79 322.57,396.1 320.5,396.1 C320.5,396.1 312.62,396.1 312.62,396.1 C312.62,396.1 312.63,397.06 312.63,397.99 C312.63,398.61 312,399.86 310.75,399.86 C309.5,399.86 308.88,398.61 308.88,397.98 C308.88,397.98 308.87,396.1 308.87,396.1 C308.87,396.1 301.88,396.1 301.88,396.1 C300.84,396.1 300,395.26 300,394.23 C300,393.19 300.84,392.35 301.88,392.35 C301.88,392.35 308.87,392.35 308.87,392.35 C308.87,392.35 308.87,390.47 308.87,390.47 C308.87,389.83 309.5,388.5 310.75,388.5 C312,388.5 312.62,389.84 312.62,390.47 C312.62,390.47 312.62,392.35 312.62,392.35 C312.62,392.35 321.75,392.35 321.75,392.35 C325.2,392.35 328,395.15 328,398.61z "/>
                                                        </g>
                                                    </g>
                                                    <g id="_R_G_L_0_G" transform=" translate(125.555, 126.412) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
                                                        <g clip-path="url(#_R_G_L_0_C_0)">
                                                            <path id="_R_G_L_0_G_G_0_D_0_P_0" class="bpa-front-loader-cl-primary" fill-opacity="1" fill-rule="nonzero" d=" M305.86 420.29 C305.86,420.29 307.11,419.04 307.11,415.28 C307.11,409.01 303.36,407.76 298.36,407.76 C298.36,407.76 287.11,407.76 287.11,407.76 C287.11,407.76 287.11,434.08 287.11,434.08 C287.11,434.08 294.61,434.08 294.61,434.08 C294.61,434.08 294.61,441.6 294.61,441.6 C294.61,441.6 298.36,441.6 298.36,441.6 C298.36,441.6 298.36,434.08 298.36,434.08 C302.71,434.08 305.73,434.08 307.98,431.3 C309.07,429.95 309.62,428.24 309.61,426.5 C309.61,425.58 309.51,424.67 309.3,424.05 C308.73,422.65 308.36,421.55 305.86,420.29z  M302.11 430.32 C302.11,430.32 298.36,430.32 298.36,430.32 C298.36,430.32 298.36,426.56 298.36,426.56 C298.36,424.48 300.03,422.8 302.11,422.8 C304.13,422.8 305.86,424.43 305.86,426.56 C305.86,428.78 304.03,430.32 302.11,430.32z  M299.07 419.95 C298.43,420.26 297.82,420.63 297.26,421.05 C295.87,422.1 294.61,423.58 294.61,426.56 C294.61,426.56 294.61,430.32 294.61,430.32 C294.61,430.32 290.86,430.32 290.86,430.32 C290.86,430.32 290.86,411.52 290.86,411.52 C290.86,411.52 298.36,411.52 298.36,411.52 C301.35,411.52 303.36,412.77 303.36,415.28 C303.36,417.58 301.65,418.68 299.07,419.95z "/>
                                                        </g>
                                                    </g>
                                                </g>
                                                <g id="time_group"/>
                                            </svg>
                                        </div>
									</div>
								</div>
                                <el-row>
                                    <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                                        <div class="bpa-front-module-heading"><?php echo esc_html($bookingpress_second_tab_name); ?></div>
                                        <div class="bpa-front-module--note-desc" v-if="date_time_step_note !=''"><?php echo wp_kses($bookingpress_date_time_note, $bookingpress_allow_tag); ?></div>
                                    </el-col>
                                </el-row>
                                <div class="bpa-front--dt__wrapper">
                                    <div class="bpa-front--dt__col" :class="(isLoadDateTimeCalendarLoad == 0 ) ? 'bpa-front-dt-col__is-visible' : ''">
                                        <div class="bpa-front--dt__calendar">
                                            <v-date-picker v-if="bookingpress_current_tab == 'datetime'" mode="date" ref="bkp_front_calendar" :min-date="jsCurrentDate" :max-date="booking_cal_maxdate" v-model="appointment_step_form_data.selected_date" @dayclick="dayClicked" :disabled-dates="[{start:new Date(jsCurrentDate), end: new Date(booking_cal_maxdate)}]" :available-dates="v_calendar_available_dates" @update:v-month-page="bpaMoveMonth" :first-day-of-week="first_day_of_week" :locale="site_locale" class="bpa-front-v-date-picker" :masks="{weekdays: 'WWW'}" is-required :model-config="modelConfig" />
                                        </div>
                                    </div>
                                    <div class="bpa-front--dt__col" :class="(isLoadDateTimeCalendarLoad == 0 ) ? 'bpa-front-dt-col__is-visible' : ''">                                        
                                        <div class="bpa-front--dt__time-slots">
                                            <div class="bpa-front-loader-container" v-if="service_timing == '-2' && service_timing != 'null'">
                                                <div class="bpa-front-loader">
													<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid meet" width="256" height="256" viewBox="0 0 256 256" style="width:100%;height:100%">
														<defs>
															<animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_1_C_0_P_0" fill="freeze" attributeName="d" attributeType="XML" from="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z " to="M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z " keyTimes="0;0.5037594;0.5263158;0.5789474;0.6691729;0.6992481;0.7593985;0.7669173;1" values="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M303.49 386.7 C303.49,386.7 284.88,386.7 284.88,386.7 C284.88,386.7 284.88,402.72 284.88,402.72 C284.88,402.72 293.41,402.87 293.41,402.87 C293.41,402.87 293.07,405.24 293.07,405.24 C293.07,405.24 296.63,405.24 296.63,405.24 C296.63,405.24 296.82,402.57 296.82,402.57 C296.82,402.57 304.49,401.98 304.49,401.98 C304.49,401.98 303.49,386.7 303.49,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,398.12 265.56,398.12 C265.56,398.12 266.75,407.02 266.75,407.02 C266.75,407.02 294.78,405.83 294.78,405.83 C294.78,405.83 298.34,405.83 298.34,405.83 C298.34,405.83 332.75,406.72 332.75,406.72 C332.75,406.72 332.45,399.46 332.45,399.46 C332.45,399.46 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,442.32 265.56,442.32 C265.56,442.32 266.75,448.4 266.75,448.4 C266.75,448.4 283.8,447.51 283.8,447.51 C283.8,447.51 312.06,447.21 312.06,447.21 C312.06,447.21 332.75,448.1 332.75,448.1 C332.75,448.1 332.45,443.65 332.45,443.65 C332.45,443.65 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.86,453.14 265.86,453.14 C265.86,453.14 276.98,456.11 276.98,456.11 C276.98,456.11 277.28,447.51 277.28,447.51 C277.28,447.51 319.47,447.81 319.47,447.81 C319.47,447.81 318.81,456.11 318.81,456.11 C318.81,456.11 329.63,454.92 329.63,454.92 C329.63,454.92 330.97,386.7 330.97,386.7z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.63,448.83 295.63,448.83 C295.63,448.83 295.71,448.75 295.71,448.75 C295.71,448.75 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z " keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0" calcMode="spline"/>
															<clipPath id="_R_G_L_1_C_0">
																<path id="_R_G_L_1_C_0_P_0" fill-rule="nonzero"/>
															</clipPath>
															<animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_0_C_0_P_0" fill="freeze" attributeName="d" attributeType="XML" from="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z " to="M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z " keyTimes="0;0.1804511;0.2180451;0.2481203;0.2631579;0.2706767;0.2781955;0.2857143;0.3157895;0.3308271;0.3533835;0.3834586;0.406015;0.4135338;0.4210526;0.4511278;0.4736842;0.4887218;0.4962406;1" values="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M310.92 429.74 C310.92,429.74 310.97,429.75 310.97,429.75 C310.97,429.75 310.93,429.74 310.93,429.74 C310.93,429.74 310.91,429.77 310.91,429.77 C310.91,429.77 310.94,429.77 310.94,429.77 C310.94,429.77 310.99,429.77 310.99,429.77 C310.99,429.77 311.09,429.7 311.09,429.7 C311.09,429.7 310.99,429.73 310.99,429.73 C310.99,429.73 310.9,434.91 310.9,434.91 C310.9,434.91 312.25,433.8 312.25,433.8 C312.25,433.8 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 303.93,428.18 303.93,428.18 C303.93,428.18 303.66,428.14 303.66,428.14 C303.66,428.14 303.84,428.16 303.84,428.16 C303.84,428.16 303.52,428.11 303.52,428.11 C303.52,428.11 303.67,428.12 303.67,428.12 C303.67,428.12 303.58,428.1 303.58,428.1 C303.58,428.1 303.49,428.3 303.49,428.11 C303.49,427.93 303.63,428.09 303.63,428.09 C303.63,428.09 303.45,428.1 303.45,428.1 C303.45,428.1 303.76,428.04 303.76,428.04 C303.76,428.04 303.73,428 303.73,428 C303.73,428 303.69,427.98 303.69,427.98 C303.69,427.98 303.71,428.13 303.71,428.13 C303.71,428.13 303.76,428.08 303.76,428.08 C303.76,428.08 303.8,428.06 303.8,428.06 C303.8,428.06 303.8,428.11 303.8,428.11 C303.8,428.11 303.58,428.16 303.58,428.16 C303.58,428.16 310.92,429.75 310.92,429.75 C310.92,429.75 310.91,429.75 310.91,429.75 C310.91,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.9,429.75 310.9,429.75 C310.9,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.92,429.74 310.92,429.74z ;M299.65 434.12 C299.65,434.12 299.7,434.13 299.7,434.13 C299.7,434.13 299.66,434.11 299.66,434.11 C299.66,434.11 299.64,434.14 299.64,434.14 C299.64,434.14 299.66,434.14 299.66,434.14 C299.66,434.14 299.72,434.15 299.72,434.15 C299.72,434.15 299.81,434.08 299.81,434.08 C299.81,434.08 299.72,434.11 299.72,434.11 C299.72,434.11 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 300.06,430.31 300.06,430.31 C300.06,430.31 299.78,430.27 299.78,430.27 C299.78,430.27 299.96,430.29 299.96,430.29 C299.96,430.29 299.65,430.25 299.65,430.25 C299.65,430.25 299.8,430.25 299.8,430.25 C299.8,430.25 299.7,430.24 299.7,430.24 C299.7,430.24 299.61,430.43 299.61,430.25 C299.61,430.06 299.75,430.22 299.75,430.22 C299.75,430.22 299.57,430.23 299.57,430.23 C299.57,430.23 299.89,430.17 299.89,430.17 C299.89,430.17 299.85,430.13 299.85,430.13 C299.85,430.13 299.82,430.12 299.82,430.12 C299.82,430.12 299.83,430.26 299.83,430.26 C299.83,430.26 299.89,430.21 299.89,430.21 C299.89,430.21 299.93,430.19 299.93,430.19 C299.93,430.19 299.93,430.25 299.93,430.25 C299.93,430.25 299.7,430.29 299.7,430.29 C299.7,430.29 299.65,434.13 299.65,434.13 C299.65,434.13 299.64,434.13 299.64,434.13 C299.64,434.13 299.66,434.13 299.66,434.13 C299.66,434.13 299.63,434.13 299.63,434.13 C299.63,434.13 299.65,434.13 299.65,434.13 C299.65,434.13 299.65,434.12 299.65,434.12z ;M292.83 434.12 C292.83,434.12 292.81,434.11 292.81,434.11 C292.81,434.11 292.84,434.12 292.84,434.12 C292.84,434.12 292.82,434.15 292.82,434.15 C292.82,434.15 292.85,434.15 292.85,434.15 C292.85,434.15 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 292.89,430.31 292.89,430.31 C292.89,430.31 292.69,430.25 292.69,430.25 C292.69,430.25 292.72,430.28 292.72,430.28 C292.72,430.28 292.63,430.26 292.63,430.26 C292.63,430.26 292.65,430.43 292.65,430.25 C292.65,430.06 292.56,430.15 292.56,430.15 C292.56,430.15 292.61,430.23 292.61,430.23 C292.61,430.23 292.93,430.17 292.93,430.17 C292.93,430.17 292.89,430.13 292.89,430.13 C292.89,430.13 292.85,430.12 292.85,430.12 C292.85,430.12 292.87,430.26 292.87,430.26 C292.87,430.26 292.93,430.21 292.93,430.21 C292.93,430.21 292.96,430.19 292.96,430.19 C292.96,430.19 292.96,430.25 292.96,430.25 C292.96,430.25 292.77,430.22 292.77,430.22 C292.77,430.22 292.83,434.13 292.83,434.13 C292.83,434.13 292.82,434.13 292.82,434.13 C292.82,434.13 292.84,434.13 292.84,434.13 C292.84,434.13 292.81,434.13 292.81,434.13 C292.81,434.13 292.83,434.13 292.83,434.13 C292.83,434.13 292.83,434.12 292.83,434.12z ;M286.91 434.04 C286.91,434.04 286.89,434.02 286.89,434.02 C286.89,434.02 286.92,434.03 286.92,434.03 C286.92,434.03 286.9,434.06 286.9,434.06 C286.9,434.06 286.92,434.06 286.92,434.06 C286.92,434.06 294.61,434.08 294.61,434.08 C294.61,434.08 298.39,434.03 298.39,434.03 C298.39,434.03 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.91,428.68 291.91,428.68 C291.91,428.68 291.82,428.67 291.82,428.67 C291.82,428.67 291.88,428.65 291.88,428.46 C291.88,428.28 291.78,428.37 291.78,428.37 C291.78,428.37 291.84,428.44 291.84,428.44 C291.84,428.44 292.15,428.39 292.15,428.39 C292.15,428.39 292.12,428.35 292.12,428.35 C292.12,428.35 292.08,428.33 292.08,428.33 C292.08,428.33 292.1,428.48 292.1,428.48 C292.1,428.48 292.15,428.42 292.15,428.42 C292.15,428.42 292.19,428.41 292.19,428.41 C292.19,428.41 292.19,428.46 292.19,428.46 C292.19,428.46 291.97,428.51 291.97,428.51 C291.97,428.51 287.14,434.07 287.14,434.07 C287.14,434.07 286.89,434.05 286.89,434.05 C286.89,434.05 286.92,434.05 286.92,434.05 C286.92,434.05 286.89,434.05 286.89,434.05 C286.89,434.05 286.91,434.05 286.91,434.05 C286.91,434.05 286.91,434.04 286.91,434.04z ;M286.7 429.47 C286.7,429.47 286.88,429.37 286.88,429.37 C286.88,429.37 286.52,429.45 286.52,429.45 C286.52,429.45 286.83,429.85 286.83,429.85 C286.83,429.85 286.14,434.18 286.14,434.18 C286.14,434.18 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.08 298.37,434.08 C298.37,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.38,430.31 298.38,430.31 C298.38,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.99,426.42 291.99,426.42 C291.99,426.42 291.87,426.34 291.87,426.34 C291.87,426.34 292.01,426.25 292.01,426.07 C292.01,425.88 292.05,425.99 292.05,425.99 C292.05,425.99 291.97,425.95 291.97,425.95 C291.97,425.95 292.39,425.98 292.39,425.98 C292.39,425.98 292.27,426.05 292.27,426.05 C292.27,426.05 292.35,425.99 292.35,425.99 C292.35,425.99 292.32,426 292.32,426 C292.32,426 292.4,426 292.4,426 C292.4,426 292.4,426.06 292.4,426.06 C292.4,426.06 292.39,426.05 292.39,426.05 C292.39,426.05 292.62,426.45 292.62,426.45 C292.62,426.45 286.78,429.41 286.78,429.41 C286.78,429.41 286.55,429.2 286.55,429.2 C286.55,429.2 286.62,429.38 286.62,429.38 C286.62,429.38 286.51,429.44 286.51,429.44 C286.51,429.44 286.46,429.37 286.46,429.37 C286.46,429.37 286.7,429.47 286.7,429.47z ;M286.5 424.9 C286.5,424.9 286.87,424.72 286.87,424.72 C286.87,424.72 286.13,424.87 286.13,424.87 C286.13,424.87 286.76,425.64 286.76,425.64 C286.76,425.64 285.37,434.3 285.37,434.3 C285.37,434.3 294.63,434.09 294.63,434.09 C294.63,434.09 298.37,434.09 298.37,434.09 C298.37,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.36,430.31 298.36,430.31 C298.36,430.31 294.59,430.33 294.59,430.33 C294.59,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.06,424.16 292.06,424.16 C292.06,424.16 291.91,424.01 291.91,424.01 C291.91,424.01 292.13,423.86 292.13,423.68 C292.13,423.49 292.32,423.6 292.32,423.6 C292.32,423.6 292.1,423.46 292.1,423.46 C292.1,423.46 292.62,423.57 292.62,423.57 C292.62,423.57 292.43,423.75 292.43,423.75 C292.43,423.75 292.62,423.64 292.62,423.64 C292.62,423.64 292.54,423.53 292.54,423.53 C292.54,423.53 292.65,423.57 292.65,423.57 C292.65,423.57 292.62,423.72 292.62,423.72 C292.62,423.72 292.58,423.64 292.58,423.64 C292.58,423.64 293.27,424.39 293.27,424.39 C293.27,424.39 286.43,424.75 286.43,424.75 C286.43,424.75 286.2,424.35 286.2,424.35 C286.2,424.35 286.31,424.72 286.31,424.72 C286.31,424.72 286.13,424.83 286.13,424.83 C286.13,424.83 286.02,424.68 286.02,424.68 C286.02,424.68 286.5,424.9 286.5,424.9z ;M285.53 417.93 C285.53,417.93 285.61,418.01 285.61,418.01 C285.61,418.01 285.39,417.97 285.39,417.97 C285.39,417.97 285.68,418.12 285.68,418.12 C285.68,418.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.38,434.11 298.38,434.11 C298.38,434.11 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.71,430.31 298.71,430.31 C298.71,430.31 293.3,430.31 293.3,430.31 C293.3,430.31 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.26,417.75 291.26,417.56 C291.26,417.38 291.34,417.38 291.34,417.38 C291.34,417.38 291.45,417.54 291.45,417.54 C291.45,417.54 291.21,417.5 291.21,417.5 C291.21,417.5 291.32,417.45 291.32,417.45 C291.32,417.45 291.28,417.51 291.28,417.51 C291.28,417.51 291.5,417.56 291.5,417.56 C291.5,417.56 291.52,417.54 291.52,417.54 C291.52,417.54 291.45,417.6 291.45,417.6 C291.45,417.6 291.43,417.67 291.43,417.67 C291.43,417.67 291.41,417.89 291.41,417.89 C291.41,417.89 291.24,417.95 291.24,417.95 C291.24,417.95 285.98,417.86 285.98,417.86 C285.98,417.86 286.02,417.69 286.02,417.69 C286.02,417.69 285.92,417.77 285.92,417.77 C285.92,417.77 285.81,417.62 285.81,417.62 C285.81,417.62 285.53,417.93 285.53,417.93z ;M284.93 404.18 C284.93,404.18 281.14,411.97 281.14,411.97 C281.14,411.97 273.88,412.04 273.88,412.04 C273.88,412.04 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.08 298.36,434.08 C298.36,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.35,430.31 298.35,430.31 C298.35,430.31 294.59,430.32 294.59,430.32 C294.59,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 291.91,415.81 291.91,415.81 C291.91,415.81 291.8,415.82 291.8,415.82 C291.8,415.82 291.88,415.73 291.88,415.73 C291.88,415.73 291.9,415.66 291.9,415.66 C291.9,415.66 291.8,415.65 291.8,415.65 C291.8,415.65 291.73,415.73 291.73,415.73 C291.73,415.73 291.87,415.58 291.87,415.58 C291.87,415.58 291.87,415.71 291.87,415.71 C291.87,415.71 291.83,415.72 291.83,415.72 C291.83,415.72 291.82,415.71 291.82,415.71 C291.82,415.71 291.66,414.92 291.66,414.92 C291.66,414.92 291.45,413.38 291.45,413.38 C291.45,413.38 291.09,411.81 291.09,411.81 C291.09,411.81 291.05,411.77 291.05,411.77 C291.05,411.77 289.08,410.26 289.08,410.26 C289.08,410.26 284.93,404.18 284.93,404.18z ;M298.66 404.21 C298.66,404.21 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.76,430.32 298.76,430.32 C298.76,430.32 294.62,430.33 294.62,430.33 C294.62,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 300.75,413.19 300.75,413.19 C300.75,413.19 300.74,413.2 300.74,413.2 C300.74,413.2 300.68,413.28 300.68,413.28 C300.68,413.28 300.74,413.15 300.74,413.15 C300.74,413.15 300.76,413.19 300.76,413.19 C300.76,413.19 300.77,413.17 300.77,413.17 C300.77,413.17 303.55,406.44 303.55,406.44 C303.55,406.44 302.85,404.47 302.85,404.47 C302.85,404.47 301.29,403.47 301.29,403.47 C301.29,403.47 301.18,403.32 301.18,403.32 C301.18,403.32 298.66,404.21 298.66,404.21z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.07 294.61,434.07 C294.61,434.07 298.36,434.07 298.36,434.07 C298.36,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.73,430.31 298.73,430.31 C298.73,430.31 293.3,430.33 293.3,430.33 C293.3,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.59,416.02 302.59,416.02 C302.59,416.02 302.55,415.98 302.55,415.98 C302.55,415.98 302.63,415.99 302.63,415.99 C302.63,415.99 306.67,409.55 306.67,409.55 C306.67,409.55 306.65,409.61 306.65,409.61 C306.65,409.61 306.59,409.55 306.59,409.55 C306.59,409.55 306.69,409.72 306.69,409.72 C306.69,409.72 306.58,409.57 306.58,409.57 C306.58,409.57 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.29,420.1 306.29,420.1 C306.29,420.1 301.7,423.39 301.7,423.39 C301.7,423.39 298.38,430.31 298.38,430.31 C298.38,430.31 293.4,430.32 293.4,430.32 C293.4,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.63,417.02 302.63,417.02 C302.63,417.02 302.61,416.97 302.61,416.97 C302.61,416.97 302.63,416.9 302.63,416.9 C302.63,416.9 307.12,415.55 307.12,415.55 C307.12,415.55 307.51,415.47 307.51,415.47 C307.51,415.47 307.52,415.47 307.52,415.47 C307.52,415.47 309.01,412.56 309.01,412.56 C309.01,412.56 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.08 294.6,434.08 C294.6,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.05,420.2 306.05,420.2 C306.05,420.2 301.63,423.29 301.63,423.29 C301.63,423.29 298.57,430.33 298.57,430.33 C298.57,430.33 293.35,430.32 293.35,430.32 C293.35,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.72,417.16 306.72,417.16 C306.72,417.16 307.56,417.29 307.56,417.29 C307.56,417.29 307.59,417.33 307.59,417.33 C307.59,417.33 308.54,413.47 308.54,413.47 C308.54,413.47 306.71,408.22 306.71,408.22 C306.71,408.22 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.62,434.09 294.62,434.09 C294.62,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.8,420.3 305.8,420.3 C305.8,420.3 301.55,423.2 301.55,423.2 C301.55,423.2 298.74,430.31 298.74,430.31 C298.74,430.31 293.34,430.32 293.34,430.32 C293.34,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.32,418.77 306.32,418.77 C306.32,418.77 307.34,417.78 307.34,417.78 C307.34,417.78 307.74,418.52 307.74,418.52 C307.74,418.52 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.09 294.6,434.09 C294.6,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.98,420.3 305.98,420.3 C305.98,420.3 301.72,423.59 301.72,423.59 C301.72,423.59 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 296.68,421.72 296.68,421.72 C296.68,421.72 300.57,423.18 300.57,423.18 C300.57,423.18 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.41,419.97 306.41,419.97 C306.41,419.97 301.7,423.64 301.7,423.64 C301.7,423.64 298.69,430.31 298.69,430.31 C298.69,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 294.58,430.33 294.58,430.33 C294.58,430.33 298.38,430.31 298.38,430.31 C298.38,430.31 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.73,439.55 293.73,439.55 C293.73,439.55 298.46,439.54 298.46,439.54 C298.46,439.54 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.43,419.98 306.43,419.98 C306.43,419.98 301.75,423.57 301.75,423.57 C301.75,423.57 298.73,430.27 298.73,430.27 C298.73,430.27 293.72,430.3 293.72,430.3 C293.72,430.3 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.7,430.31 293.7,430.31 C293.7,430.31 298.74,430.26 298.74,430.26 C298.74,430.26 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z " keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0" calcMode="spline"/>
															<clipPath id="_R_G_L_0_C_0">
																<path id="_R_G_L_0_C_0_P_0" fill-rule="nonzero"/>
															</clipPath>
															<animate attributeType="XML" attributeName="opacity" dur="2s" from="0" to="1" xlink:href="#time_group"/>
														</defs>
														<g id="_R_G">
															<g id="_R_G_L_1_G" transform=" translate(127.638, 127.945) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
																<g clip-path="url(#_R_G_L_1_C_0)">
																	<path id="_R_G_L_1_G_G_0_D_0_P_0" class="bpa-front-loader-cl-primary" fill-opacity="1" fill-rule="nonzero" d=" M328 398.61 C328,398.61 328,446.23 328,446.23 C328,449.7 325.2,452.5 321.75,452.5 C321.75,452.5 274.25,452.5 274.25,452.5 C270.8,452.5 268,449.7 268,446.23 C268,446.23 268,398.61 268,398.61 C268,395.15 270.8,392.35 274.25,392.35 C274.25,392.35 283.46,392.26 283.46,392.26 C283.46,392.26 283.46,390.38 283.46,390.38 C283.46,389.76 284.08,388.5 285.33,388.5 C286.58,388.5 287.21,389.75 287.21,390.38 C287.21,390.38 287.21,397.89 287.21,397.89 C287.21,398.53 286.59,399.78 285.33,399.78 C284.08,399.78 283.46,398.53 283.46,397.9 C283.46,397.9 283.46,396.02 283.46,396.02 C283.46,396.02 275.5,396.1 275.5,396.1 C273.43,396.1 271.75,397.79 271.75,399.86 C271.75,399.86 271.75,444.98 271.75,444.98 C271.75,447.06 273.43,448.74 275.5,448.74 C275.5,448.74 320.5,448.74 320.5,448.74 C322.57,448.74 324.25,447.06 324.25,444.98 C324.25,444.98 324.25,399.86 324.25,399.86 C324.25,397.79 322.57,396.1 320.5,396.1 C320.5,396.1 312.62,396.1 312.62,396.1 C312.62,396.1 312.63,397.06 312.63,397.99 C312.63,398.61 312,399.86 310.75,399.86 C309.5,399.86 308.88,398.61 308.88,397.98 C308.88,397.98 308.87,396.1 308.87,396.1 C308.87,396.1 301.88,396.1 301.88,396.1 C300.84,396.1 300,395.26 300,394.23 C300,393.19 300.84,392.35 301.88,392.35 C301.88,392.35 308.87,392.35 308.87,392.35 C308.87,392.35 308.87,390.47 308.87,390.47 C308.87,389.83 309.5,388.5 310.75,388.5 C312,388.5 312.62,389.84 312.62,390.47 C312.62,390.47 312.62,392.35 312.62,392.35 C312.62,392.35 321.75,392.35 321.75,392.35 C325.2,392.35 328,395.15 328,398.61z "/>
																</g>
															</g>
															<g id="_R_G_L_0_G" transform=" translate(125.555, 126.412) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
																<g clip-path="url(#_R_G_L_0_C_0)">
																	<path id="_R_G_L_0_G_G_0_D_0_P_0" class="bpa-front-loader-cl-primary" fill-opacity="1" fill-rule="nonzero" d=" M305.86 420.29 C305.86,420.29 307.11,419.04 307.11,415.28 C307.11,409.01 303.36,407.76 298.36,407.76 C298.36,407.76 287.11,407.76 287.11,407.76 C287.11,407.76 287.11,434.08 287.11,434.08 C287.11,434.08 294.61,434.08 294.61,434.08 C294.61,434.08 294.61,441.6 294.61,441.6 C294.61,441.6 298.36,441.6 298.36,441.6 C298.36,441.6 298.36,434.08 298.36,434.08 C302.71,434.08 305.73,434.08 307.98,431.3 C309.07,429.95 309.62,428.24 309.61,426.5 C309.61,425.58 309.51,424.67 309.3,424.05 C308.73,422.65 308.36,421.55 305.86,420.29z  M302.11 430.32 C302.11,430.32 298.36,430.32 298.36,430.32 C298.36,430.32 298.36,426.56 298.36,426.56 C298.36,424.48 300.03,422.8 302.11,422.8 C304.13,422.8 305.86,424.43 305.86,426.56 C305.86,428.78 304.03,430.32 302.11,430.32z  M299.07 419.95 C298.43,420.26 297.82,420.63 297.26,421.05 C295.87,422.1 294.61,423.58 294.61,426.56 C294.61,426.56 294.61,430.32 294.61,430.32 C294.61,430.32 290.86,430.32 290.86,430.32 C290.86,430.32 290.86,411.52 290.86,411.52 C290.86,411.52 298.36,411.52 298.36,411.52 C301.35,411.52 303.36,412.77 303.36,415.28 C303.36,417.58 301.65,418.68 299.07,419.95z "/>
																</g>
															</g>
														</g>
														<g id="time_group"/>
													</svg>
												</div>
                                            </div>
                                            <div class="bpa-front--dt__ts-heading">
                                                <div class="bpa-front-module-heading"><?php echo esc_html($bookingpress_timeslot_title); ?></div>
                                            </div>
                                            <div class="bpa-front--dt__ts-body bpa-front__no-timeslots-body" v-if="no_timeslot_available != '' && no_timeslot_available == true"> 
                                                <svg viewBox="0 0 120 121" xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M108.486 103.08C101.042 112.139 86.7296 109.719 75.3575 112.572C64.3105 115.344 53.4388 123.192 42.6284 119.606C31.8342 116.026 27.8283 103.242 20.6455 94.4249C13.5882 85.7617 2.04617 79.3615 0.797986 68.2575C-0.448903 57.1649 8.61128 47.9531 14.3452 38.376C19.5416 29.6967 24.6347 21.093 32.6953 14.9808C41.3289 8.43396 51.0768 2.35675 61.9118 2.30667C72.8285 2.25621 82.086 9.1904 91.5052 14.709C101.484 20.5552 114.441 24.5839 118.451 35.4317C122.456 46.2671 113.129 57.2263 111.445 68.6549C109.732 80.2849 115.949 93.9976 108.486 103.08Z"
                                                        class="bpa-front-dev__panel-bg" />
                                                    <g filter="url(#filter0_d_4344_13430)">
                                                        <rect x="16.3105" y="27.8936" width="95.3718" height="22.2173" rx="11.1086"
                                                            class="bpa-front-dev__form-bg" />
                                                    </g>
                                                    <circle cx="27.1474" cy="39.0009" r="5.41885" class="bpa-front-dev__primary-bg" />
                                                    <rect x="37.9863" y="39.542" width="41.1833" height="2.16754" rx="1.08377" fill="#F4F7FB" />
                                                    <rect x="37.9863" y="36.0215" width="13.5471" height="2.16754" rx="1.08377" fill="#F4F7FB" />
                                                    <rect x="53.4297" y="36.0215" width="25.7395" height="2.16754" rx="1.08377" fill="#F4F7FB" />
                                                    <rect x="84.5859" y="34.9375" width="21.6754" height="8.12828" rx="4" fill="#F4F7FB" />
                                                    <g filter="url(#filter1_d_4344_13430)">
                                                        <rect x="16.3105" y="54.1748" width="95.3718" height="22.2173" rx="11.1086"
                                                            class="bpa-front-dev__form-bg" />
                                                    </g>
                                                    <circle cx="27.1474" cy="65.2831" r="5.41885" fill="#E8ECF5" />
                                                    <rect x="37.9863" y="65.8252" width="41.1833" height="2.16754" rx="1.08377" fill="#E8ECF5" />
                                                    <rect x="37.9863" y="62.3037" width="13.5471" height="2.16754" rx="1.08377" fill="#DDE1ED" />
                                                    <rect x="53.4297" y="62.3037" width="25.7395" height="2.16754" rx="1.08377" fill="#E8ECF5" />
                                                    <rect x="84.5859" y="61.2197" width="21.6754" height="8.12828" rx="4" fill="#F4F7FB" />
                                                    <g filter="url(#filter2_d_4344_13430)">
                                                        <rect x="16.3105" y="80.4541" width="95.3718" height="22.2173" rx="11.1086"
                                                            class="bpa-front-dev__form-bg" />
                                                    </g>
                                                    <circle cx="27.1474" cy="91.5644" r="5.41885" fill="#E8ECF5" />
                                                    <rect x="37.9863" y="92.1064" width="41.1833" height="2.16754" rx="1.08377" fill="#E8ECF5" />
                                                    <rect x="37.9863" y="88.582" width="13.5471" height="2.16754" rx="1.08377" fill="#DDE1ED" />
                                                    <rect x="53.4297" y="88.582" width="25.7395" height="2.16754" rx="1.08377" fill="#E8ECF5" />
                                                    <rect x="84.5859" y="87.499" width="21.6754" height="8.12828" rx="4" class="bpa-front-dev__primary-bg" />
                                                    <path
                                                        d="M10.6699 62.6393C11.3924 62.6393 11.6694 61.9455 11.7176 61.5986C11.7176 62.3164 12.4642 62.6058 12.8375 62.6537C11.9704 62.6537 11.7296 63.3953 11.7176 63.7662C11.7176 62.9623 11.0191 62.6752 10.6699 62.6393Z"
                                                        stroke="#F4B125" stroke-opacity="0.6" stroke-linejoin="round" />
                                                    <line x1="11.4707" y1="60.4463" x2="11.4707" y2="60.3625" stroke="#F4B125" stroke-opacity="0.6"
                                                        stroke-linecap="round" />
                                                    <line x1="11.4707" y1="65.8652" x2="11.4707" y2="65.1312" stroke="#F4B125" stroke-opacity="0.6"
                                                        stroke-linecap="round" />
                                                    <path d="M13.4863 62.709H14.7869" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round" />
                                                    <path d="M8.7207 62.709H9.53353" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round" />
                                                    <path
                                                        d="M10.3483 40.076L10.35 40.0813H10.3556L10.3511 40.0846L10.3528 40.0898L10.3483 40.0866L10.3438 40.0898L10.3455 40.0846L10.3411 40.0813H10.3466L10.3483 40.076Z"
                                                        class="bpa-front-dev__primary-bg" />
                                                    <path
                                                        d="M117.915 48.4764L117.916 48.4817H117.922L117.917 48.485L117.919 48.4902L117.915 48.487L117.91 48.4902L117.912 48.485L117.907 48.4817H117.913L117.915 48.4764Z"
                                                        class="bpa-front-dev__primary-bg" />
                                                    <path
                                                        d="M84.5866 111.606L84.5883 111.612H84.5938L84.5894 111.615L84.5911 111.62L84.5866 111.617L84.5821 111.62L84.5838 111.615L84.5793 111.612H84.5849L84.5866 111.606Z"
                                                        stroke="#F5AE41" />
                                                    <circle cx="56.1379" cy="1.88181" r="0.854713" stroke="#EE2445" stroke-opacity="0.7" />
                                                    <circle cx="111.681" cy="79.0998" r="0.854713" stroke="#EE2445" stroke-opacity="0.6" />
                                                    <circle cx="2.76292" cy="79.0993" r="0.854713" stroke="#EE2445" stroke-opacity="0.6" />
                                                    <circle cx="69.9579" cy="15.9723" r="0.541885" fill="#2166F1" />
                                                    <line x1="43.9062" y1="16.5115" x2="43.9062" y2="20.0337" stroke="#01CB62" stroke-opacity="0.3" />
                                                    <line x1="45.3027" y1="18.6365" x2="41.7805" y2="18.6365" stroke="#01CB62" stroke-opacity="0.3" />
                                                    <line x1="21.3262" y1="105.778" x2="61.9479" y2="105.778" stroke="#DCE4F5" stroke-width="3"
                                                        stroke-linecap="round" />
                                                    <line x1="69.0176" y1="105.778" x2="87.9639" y2="105.778" stroke="#DCE4F5" stroke-width="3"
                                                        stroke-linecap="round" />
                                                    <line x1="95.8379" y1="105.778" x2="114.784" y2="105.778" stroke="#DCE4F5" stroke-width="3"
                                                        stroke-linecap="round" />
                                                    <path
                                                        d="M92.9902 15.9169C93.8934 15.9169 94.2396 15.0496 94.2998 14.616C94.2998 15.5131 95.233 15.875 95.6997 15.9348C94.6159 15.9348 94.3148 16.8619 94.2998 17.3254C94.2998 16.3206 93.4268 15.9617 92.9902 15.9169Z"
                                                        stroke="#F4B125" stroke-linejoin="round" />
                                                    <line x1="94.1113" y1="13.3025" x2="94.1113" y2="12.9478" stroke="#F4B125" stroke-linecap="round" />
                                                    <line x1="94.1113" y1="20.0769" x2="94.1113" y2="18.9094" stroke="#F4B125" stroke-linecap="round" />
                                                    <path d="M96.5098 16.0056H98.1354" stroke="#F4B125" stroke-linecap="round" />
                                                    <path d="M90.5488 16.0056H91.5649" stroke="#F4B125" stroke-linecap="round" />
                                                    <defs>
                                                        <filter id="filter0_d_4344_13430" x="8.31055" y="21.8936" width="111.372" height="38.2173"
                                                            filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                            <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                                            <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                result="hardAlpha" />
                                                            <feOffset dy="2" />
                                                            <feGaussianBlur stdDeviation="4" />
                                                            <feComposite in2="hardAlpha" operator="out" />
                                                            <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0" />
                                                            <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4344_13430" />
                                                            <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4344_13430" result="shape" />
                                                        </filter>
                                                        <filter id="filter1_d_4344_13430" x="8.31055" y="48.1748" width="111.372" height="38.2173"
                                                            filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                            <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                                            <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                result="hardAlpha" />
                                                            <feOffset dy="2" />
                                                            <feGaussianBlur stdDeviation="4" />
                                                            <feComposite in2="hardAlpha" operator="out" />
                                                            <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0" />
                                                            <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4344_13430" />
                                                            <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4344_13430" result="shape" />
                                                        </filter>
                                                        <filter id="filter2_d_4344_13430" x="8.31055" y="74.4541" width="111.372" height="38.2173"
                                                            filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                            <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                                            <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                result="hardAlpha" />
                                                            <feOffset dy="2" />
                                                            <feGaussianBlur stdDeviation="4" />
                                                            <feComposite in2="hardAlpha" operator="out" />
                                                            <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0" />
                                                            <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4344_13430" />
                                                            <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4344_13430" result="shape" />
                                                        </filter>
                                                    </defs>
                                                </svg>
                                                <div class="bpa-front-ntb__val"><?php echo esc_html($no_timeslots_available); ?></div>
                                            </div>
                                            <div class="bpa-front--dt__ts-body" v-if="service_timing != '' && service_timing != '-2'  && service_timing != 'null'">
                                                <div class="bpa-front--dt__ts-body--row" v-if="service_timing.morning_time != ''">
                                                    <div class="bpa-front--dt-ts__sub-heading"><?php echo wp_kses($bookingpress_morning_text, $bookingpress_allow_tag); ?></div>
                                                    <div class="bpa-front--dt__ts-body--items">

                                                        <div class="bpa-front--dt__ts-body--item" :class="[( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : ''),((typeof time_details.css_animation_class != 'undefined') ? time_details.css_animation_class : '')]" v-for="time_details in service_timing.morning_time" @click="(!time_details.is_booked) ? (time_details.is_booked || time_details.disable_flag_timeslot ) ? '' : selectTiming(time_details.start_time, time_details.end_time,'','','',time_details.formatted_start_time,time_details.formatted_end_time,time_details) : ''">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }}
                                                            </span>
                                                        </div>

                                                    </div>
                                                </div>
                                                <div class="bpa-front--dt__ts-body--row" v-if="service_timing.afternoon_time != ''">
                                                    <div class="bpa-front--dt-ts__sub-heading"><?php echo wp_kses($bookingpress_afternoon_text, $bookingpress_allow_tag); ?></div>
                                                    <div class="bpa-front--dt__ts-body--items">
                                                        <div class="bpa-front--dt__ts-body--item" :class="[( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : ''),((typeof time_details.css_animation_class != 'undefined') ? time_details.css_animation_class : '')]" v-for="time_details in service_timing.afternoon_time" @click="(!time_details.is_booked) ? (time_details.is_booked || time_details.disable_flag_timeslot ) ? '' : selectTiming(time_details.start_time, time_details.end_time,'','','',time_details.formatted_start_time,time_details.formatted_end_time,time_details) : ''">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="bpa-front--dt__ts-body--row" v-if="service_timing.evening_time != ''">
                                                    <div class="bpa-front--dt-ts__sub-heading"><?php echo wp_kses($bookingpress_evening_text, $bookingpress_allow_tag); ?></div>
                                                    <div class="bpa-front--dt__ts-body--items">
                                                        <div class="bpa-front--dt__ts-body--item" :class="[( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : ''),((typeof time_details.css_animation_class != 'undefined') ? time_details.css_animation_class : '')]" v-for="time_details in service_timing.evening_time" @click="(!time_details.is_booked) ? (time_details.is_booked || time_details.disable_flag_timeslot ) ? '' : selectTiming(time_details.start_time, time_details.end_time,'','','',time_details.formatted_start_time,time_details.formatted_end_time,time_details) : ''">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="bpa-front--dt__ts-body--row" v-if="service_timing.night_time != ''">
                                                    <div class="bpa-front--dt-ts__sub-heading"><?php echo wp_kses($bookingpress_night_text, $bookingpress_allow_tag); ?></div>
                                                    <div class="bpa-front--dt__ts-body--items">
                                                        <div class="bpa-front--dt__ts-body--item" :class="[( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : ''),((typeof time_details.css_animation_class != 'undefined') ? time_details.css_animation_class : '')]" v-for="time_details in service_timing.night_time" @click="( !time_details.is_booked ) ? (time_details.is_booked || time_details.disable_flag_timeslot ) ? '' : selectTiming(time_details.start_time, time_details.end_time,'','','',time_details.formatted_start_time,time_details.formatted_end_time,time_details) : ''">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                    
                                    </div>    
                                </div>
                            </div>
                        </el-col>
                    </el-row>

                    <?php /* Calendar Responsive Div */ ?>
                    <el-row>
                        <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                            <div class="bpa-front-module-container bpa-front-module--date-and-time __sm">                                
                                <el-row>
                                    <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                                        <div class="bpa-front-module-heading"><?php echo esc_html($bookingpress_second_tab_name); ?></div>
                                        <div class="bpa-front-module--note-desc"><?php echo wp_kses($bookingpress_date_time_note, $bookingpress_allow_tag); ?></div>
                                    </el-col>
                                </el-row>
                                <el-row :gutter="40" type="flex">
                                    <el-col :xs="24" :sm="12" :md="12" :lg="12" :xl="12" v-if="displayResponsiveCalendar == '1'">                                        
                                        <div class="bpa-front--dt__calendar" v-if="displayResponsiveCalendar == '1' ">
                                            <div class="bpa-front-loader-container" v-if="service_timing == '-3'">
												<div class="bpa-front-loader">													
                                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
														preserveAspectRatio="xMidYMid meet" width="256" height="256" viewBox="0 0 256 256"
														style="width:100%;height:100%">
														<defs>
															<animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_1_C_0_P_0_B" fill="freeze"
																attributeName="d" attributeType="XML"
																from="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z "
																to="M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z "
																keyTimes="0;0.5037594;0.5263158;0.5789474;0.6691729;0.6992481;0.7593985;0.7669173;1"
																values="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M303.49 386.7 C303.49,386.7 284.88,386.7 284.88,386.7 C284.88,386.7 284.88,402.72 284.88,402.72 C284.88,402.72 293.41,402.87 293.41,402.87 C293.41,402.87 293.07,405.24 293.07,405.24 C293.07,405.24 296.63,405.24 296.63,405.24 C296.63,405.24 296.82,402.57 296.82,402.57 C296.82,402.57 304.49,401.98 304.49,401.98 C304.49,401.98 303.49,386.7 303.49,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,398.12 265.56,398.12 C265.56,398.12 266.75,407.02 266.75,407.02 C266.75,407.02 294.78,405.83 294.78,405.83 C294.78,405.83 298.34,405.83 298.34,405.83 C298.34,405.83 332.75,406.72 332.75,406.72 C332.75,406.72 332.45,399.46 332.45,399.46 C332.45,399.46 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,442.32 265.56,442.32 C265.56,442.32 266.75,448.4 266.75,448.4 C266.75,448.4 283.8,447.51 283.8,447.51 C283.8,447.51 312.06,447.21 312.06,447.21 C312.06,447.21 332.75,448.1 332.75,448.1 C332.75,448.1 332.45,443.65 332.45,443.65 C332.45,443.65 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.86,453.14 265.86,453.14 C265.86,453.14 276.98,456.11 276.98,456.11 C276.98,456.11 277.28,447.51 277.28,447.51 C277.28,447.51 319.47,447.81 319.47,447.81 C319.47,447.81 318.81,456.11 318.81,456.11 C318.81,456.11 329.63,454.92 329.63,454.92 C329.63,454.92 330.97,386.7 330.97,386.7z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.63,448.83 295.63,448.83 C295.63,448.83 295.71,448.75 295.71,448.75 C295.71,448.75 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z "
																keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0"
																calcMode="spline" />
															<clipPath id="_R_G_L_1_C_0_B">
																<path id="_R_G_L_1_C_0_P_0_B" fill-rule="nonzero" />
															</clipPath>
															<animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_0_C_0_P_0_B" fill="freeze"
																attributeName="d" attributeType="XML"
																from="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z "
																to="M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z "
																keyTimes="0;0.1804511;0.2180451;0.2481203;0.2631579;0.2706767;0.2781955;0.2857143;0.3157895;0.3308271;0.3533835;0.3834586;0.406015;0.4135338;0.4210526;0.4511278;0.4736842;0.4887218;0.4962406;1"
																values="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M310.92 429.74 C310.92,429.74 310.97,429.75 310.97,429.75 C310.97,429.75 310.93,429.74 310.93,429.74 C310.93,429.74 310.91,429.77 310.91,429.77 C310.91,429.77 310.94,429.77 310.94,429.77 C310.94,429.77 310.99,429.77 310.99,429.77 C310.99,429.77 311.09,429.7 311.09,429.7 C311.09,429.7 310.99,429.73 310.99,429.73 C310.99,429.73 310.9,434.91 310.9,434.91 C310.9,434.91 312.25,433.8 312.25,433.8 C312.25,433.8 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 303.93,428.18 303.93,428.18 C303.93,428.18 303.66,428.14 303.66,428.14 C303.66,428.14 303.84,428.16 303.84,428.16 C303.84,428.16 303.52,428.11 303.52,428.11 C303.52,428.11 303.67,428.12 303.67,428.12 C303.67,428.12 303.58,428.1 303.58,428.1 C303.58,428.1 303.49,428.3 303.49,428.11 C303.49,427.93 303.63,428.09 303.63,428.09 C303.63,428.09 303.45,428.1 303.45,428.1 C303.45,428.1 303.76,428.04 303.76,428.04 C303.76,428.04 303.73,428 303.73,428 C303.73,428 303.69,427.98 303.69,427.98 C303.69,427.98 303.71,428.13 303.71,428.13 C303.71,428.13 303.76,428.08 303.76,428.08 C303.76,428.08 303.8,428.06 303.8,428.06 C303.8,428.06 303.8,428.11 303.8,428.11 C303.8,428.11 303.58,428.16 303.58,428.16 C303.58,428.16 310.92,429.75 310.92,429.75 C310.92,429.75 310.91,429.75 310.91,429.75 C310.91,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.9,429.75 310.9,429.75 C310.9,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.92,429.74 310.92,429.74z ;M299.65 434.12 C299.65,434.12 299.7,434.13 299.7,434.13 C299.7,434.13 299.66,434.11 299.66,434.11 C299.66,434.11 299.64,434.14 299.64,434.14 C299.64,434.14 299.66,434.14 299.66,434.14 C299.66,434.14 299.72,434.15 299.72,434.15 C299.72,434.15 299.81,434.08 299.81,434.08 C299.81,434.08 299.72,434.11 299.72,434.11 C299.72,434.11 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 300.06,430.31 300.06,430.31 C300.06,430.31 299.78,430.27 299.78,430.27 C299.78,430.27 299.96,430.29 299.96,430.29 C299.96,430.29 299.65,430.25 299.65,430.25 C299.65,430.25 299.8,430.25 299.8,430.25 C299.8,430.25 299.7,430.24 299.7,430.24 C299.7,430.24 299.61,430.43 299.61,430.25 C299.61,430.06 299.75,430.22 299.75,430.22 C299.75,430.22 299.57,430.23 299.57,430.23 C299.57,430.23 299.89,430.17 299.89,430.17 C299.89,430.17 299.85,430.13 299.85,430.13 C299.85,430.13 299.82,430.12 299.82,430.12 C299.82,430.12 299.83,430.26 299.83,430.26 C299.83,430.26 299.89,430.21 299.89,430.21 C299.89,430.21 299.93,430.19 299.93,430.19 C299.93,430.19 299.93,430.25 299.93,430.25 C299.93,430.25 299.7,430.29 299.7,430.29 C299.7,430.29 299.65,434.13 299.65,434.13 C299.65,434.13 299.64,434.13 299.64,434.13 C299.64,434.13 299.66,434.13 299.66,434.13 C299.66,434.13 299.63,434.13 299.63,434.13 C299.63,434.13 299.65,434.13 299.65,434.13 C299.65,434.13 299.65,434.12 299.65,434.12z ;M292.83 434.12 C292.83,434.12 292.81,434.11 292.81,434.11 C292.81,434.11 292.84,434.12 292.84,434.12 C292.84,434.12 292.82,434.15 292.82,434.15 C292.82,434.15 292.85,434.15 292.85,434.15 C292.85,434.15 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 292.89,430.31 292.89,430.31 C292.89,430.31 292.69,430.25 292.69,430.25 C292.69,430.25 292.72,430.28 292.72,430.28 C292.72,430.28 292.63,430.26 292.63,430.26 C292.63,430.26 292.65,430.43 292.65,430.25 C292.65,430.06 292.56,430.15 292.56,430.15 C292.56,430.15 292.61,430.23 292.61,430.23 C292.61,430.23 292.93,430.17 292.93,430.17 C292.93,430.17 292.89,430.13 292.89,430.13 C292.89,430.13 292.85,430.12 292.85,430.12 C292.85,430.12 292.87,430.26 292.87,430.26 C292.87,430.26 292.93,430.21 292.93,430.21 C292.93,430.21 292.96,430.19 292.96,430.19 C292.96,430.19 292.96,430.25 292.96,430.25 C292.96,430.25 292.77,430.22 292.77,430.22 C292.77,430.22 292.83,434.13 292.83,434.13 C292.83,434.13 292.82,434.13 292.82,434.13 C292.82,434.13 292.84,434.13 292.84,434.13 C292.84,434.13 292.81,434.13 292.81,434.13 C292.81,434.13 292.83,434.13 292.83,434.13 C292.83,434.13 292.83,434.12 292.83,434.12z ;M286.91 434.04 C286.91,434.04 286.89,434.02 286.89,434.02 C286.89,434.02 286.92,434.03 286.92,434.03 C286.92,434.03 286.9,434.06 286.9,434.06 C286.9,434.06 286.92,434.06 286.92,434.06 C286.92,434.06 294.61,434.08 294.61,434.08 C294.61,434.08 298.39,434.03 298.39,434.03 C298.39,434.03 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.91,428.68 291.91,428.68 C291.91,428.68 291.82,428.67 291.82,428.67 C291.82,428.67 291.88,428.65 291.88,428.46 C291.88,428.28 291.78,428.37 291.78,428.37 C291.78,428.37 291.84,428.44 291.84,428.44 C291.84,428.44 292.15,428.39 292.15,428.39 C292.15,428.39 292.12,428.35 292.12,428.35 C292.12,428.35 292.08,428.33 292.08,428.33 C292.08,428.33 292.1,428.48 292.1,428.48 C292.1,428.48 292.15,428.42 292.15,428.42 C292.15,428.42 292.19,428.41 292.19,428.41 C292.19,428.41 292.19,428.46 292.19,428.46 C292.19,428.46 291.97,428.51 291.97,428.51 C291.97,428.51 287.14,434.07 287.14,434.07 C287.14,434.07 286.89,434.05 286.89,434.05 C286.89,434.05 286.92,434.05 286.92,434.05 C286.92,434.05 286.89,434.05 286.89,434.05 C286.89,434.05 286.91,434.05 286.91,434.05 C286.91,434.05 286.91,434.04 286.91,434.04z ;M286.7 429.47 C286.7,429.47 286.88,429.37 286.88,429.37 C286.88,429.37 286.52,429.45 286.52,429.45 C286.52,429.45 286.83,429.85 286.83,429.85 C286.83,429.85 286.14,434.18 286.14,434.18 C286.14,434.18 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.08 298.37,434.08 C298.37,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.38,430.31 298.38,430.31 C298.38,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.99,426.42 291.99,426.42 C291.99,426.42 291.87,426.34 291.87,426.34 C291.87,426.34 292.01,426.25 292.01,426.07 C292.01,425.88 292.05,425.99 292.05,425.99 C292.05,425.99 291.97,425.95 291.97,425.95 C291.97,425.95 292.39,425.98 292.39,425.98 C292.39,425.98 292.27,426.05 292.27,426.05 C292.27,426.05 292.35,425.99 292.35,425.99 C292.35,425.99 292.32,426 292.32,426 C292.32,426 292.4,426 292.4,426 C292.4,426 292.4,426.06 292.4,426.06 C292.4,426.06 292.39,426.05 292.39,426.05 C292.39,426.05 292.62,426.45 292.62,426.45 C292.62,426.45 286.78,429.41 286.78,429.41 C286.78,429.41 286.55,429.2 286.55,429.2 C286.55,429.2 286.62,429.38 286.62,429.38 C286.62,429.38 286.51,429.44 286.51,429.44 C286.51,429.44 286.46,429.37 286.46,429.37 C286.46,429.37 286.7,429.47 286.7,429.47z ;M286.5 424.9 C286.5,424.9 286.87,424.72 286.87,424.72 C286.87,424.72 286.13,424.87 286.13,424.87 C286.13,424.87 286.76,425.64 286.76,425.64 C286.76,425.64 285.37,434.3 285.37,434.3 C285.37,434.3 294.63,434.09 294.63,434.09 C294.63,434.09 298.37,434.09 298.37,434.09 C298.37,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.36,430.31 298.36,430.31 C298.36,430.31 294.59,430.33 294.59,430.33 C294.59,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.06,424.16 292.06,424.16 C292.06,424.16 291.91,424.01 291.91,424.01 C291.91,424.01 292.13,423.86 292.13,423.68 C292.13,423.49 292.32,423.6 292.32,423.6 C292.32,423.6 292.1,423.46 292.1,423.46 C292.1,423.46 292.62,423.57 292.62,423.57 C292.62,423.57 292.43,423.75 292.43,423.75 C292.43,423.75 292.62,423.64 292.62,423.64 C292.62,423.64 292.54,423.53 292.54,423.53 C292.54,423.53 292.65,423.57 292.65,423.57 C292.65,423.57 292.62,423.72 292.62,423.72 C292.62,423.72 292.58,423.64 292.58,423.64 C292.58,423.64 293.27,424.39 293.27,424.39 C293.27,424.39 286.43,424.75 286.43,424.75 C286.43,424.75 286.2,424.35 286.2,424.35 C286.2,424.35 286.31,424.72 286.31,424.72 C286.31,424.72 286.13,424.83 286.13,424.83 C286.13,424.83 286.02,424.68 286.02,424.68 C286.02,424.68 286.5,424.9 286.5,424.9z ;M285.53 417.93 C285.53,417.93 285.61,418.01 285.61,418.01 C285.61,418.01 285.39,417.97 285.39,417.97 C285.39,417.97 285.68,418.12 285.68,418.12 C285.68,418.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.38,434.11 298.38,434.11 C298.38,434.11 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.71,430.31 298.71,430.31 C298.71,430.31 293.3,430.31 293.3,430.31 C293.3,430.31 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.26,417.75 291.26,417.56 C291.26,417.38 291.34,417.38 291.34,417.38 C291.34,417.38 291.45,417.54 291.45,417.54 C291.45,417.54 291.21,417.5 291.21,417.5 C291.21,417.5 291.32,417.45 291.32,417.45 C291.32,417.45 291.28,417.51 291.28,417.51 C291.28,417.51 291.5,417.56 291.5,417.56 C291.5,417.56 291.52,417.54 291.52,417.54 C291.52,417.54 291.45,417.6 291.45,417.6 C291.45,417.6 291.43,417.67 291.43,417.67 C291.43,417.67 291.41,417.89 291.41,417.89 C291.41,417.89 291.24,417.95 291.24,417.95 C291.24,417.95 285.98,417.86 285.98,417.86 C285.98,417.86 286.02,417.69 286.02,417.69 C286.02,417.69 285.92,417.77 285.92,417.77 C285.92,417.77 285.81,417.62 285.81,417.62 C285.81,417.62 285.53,417.93 285.53,417.93z ;M284.93 404.18 C284.93,404.18 281.14,411.97 281.14,411.97 C281.14,411.97 273.88,412.04 273.88,412.04 C273.88,412.04 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.08 298.36,434.08 C298.36,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.35,430.31 298.35,430.31 C298.35,430.31 294.59,430.32 294.59,430.32 C294.59,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 291.91,415.81 291.91,415.81 C291.91,415.81 291.8,415.82 291.8,415.82 C291.8,415.82 291.88,415.73 291.88,415.73 C291.88,415.73 291.9,415.66 291.9,415.66 C291.9,415.66 291.8,415.65 291.8,415.65 C291.8,415.65 291.73,415.73 291.73,415.73 C291.73,415.73 291.87,415.58 291.87,415.58 C291.87,415.58 291.87,415.71 291.87,415.71 C291.87,415.71 291.83,415.72 291.83,415.72 C291.83,415.72 291.82,415.71 291.82,415.71 C291.82,415.71 291.66,414.92 291.66,414.92 C291.66,414.92 291.45,413.38 291.45,413.38 C291.45,413.38 291.09,411.81 291.09,411.81 C291.09,411.81 291.05,411.77 291.05,411.77 C291.05,411.77 289.08,410.26 289.08,410.26 C289.08,410.26 284.93,404.18 284.93,404.18z ;M298.66 404.21 C298.66,404.21 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.76,430.32 298.76,430.32 C298.76,430.32 294.62,430.33 294.62,430.33 C294.62,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 300.75,413.19 300.75,413.19 C300.75,413.19 300.74,413.2 300.74,413.2 C300.74,413.2 300.68,413.28 300.68,413.28 C300.68,413.28 300.74,413.15 300.74,413.15 C300.74,413.15 300.76,413.19 300.76,413.19 C300.76,413.19 300.77,413.17 300.77,413.17 C300.77,413.17 303.55,406.44 303.55,406.44 C303.55,406.44 302.85,404.47 302.85,404.47 C302.85,404.47 301.29,403.47 301.29,403.47 C301.29,403.47 301.18,403.32 301.18,403.32 C301.18,403.32 298.66,404.21 298.66,404.21z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.07 294.61,434.07 C294.61,434.07 298.36,434.07 298.36,434.07 C298.36,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.73,430.31 298.73,430.31 C298.73,430.31 293.3,430.33 293.3,430.33 C293.3,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.59,416.02 302.59,416.02 C302.59,416.02 302.55,415.98 302.55,415.98 C302.55,415.98 302.63,415.99 302.63,415.99 C302.63,415.99 306.67,409.55 306.67,409.55 C306.67,409.55 306.65,409.61 306.65,409.61 C306.65,409.61 306.59,409.55 306.59,409.55 C306.59,409.55 306.69,409.72 306.69,409.72 C306.69,409.72 306.58,409.57 306.58,409.57 C306.58,409.57 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.29,420.1 306.29,420.1 C306.29,420.1 301.7,423.39 301.7,423.39 C301.7,423.39 298.38,430.31 298.38,430.31 C298.38,430.31 293.4,430.32 293.4,430.32 C293.4,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.63,417.02 302.63,417.02 C302.63,417.02 302.61,416.97 302.61,416.97 C302.61,416.97 302.63,416.9 302.63,416.9 C302.63,416.9 307.12,415.55 307.12,415.55 C307.12,415.55 307.51,415.47 307.51,415.47 C307.51,415.47 307.52,415.47 307.52,415.47 C307.52,415.47 309.01,412.56 309.01,412.56 C309.01,412.56 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.08 294.6,434.08 C294.6,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.05,420.2 306.05,420.2 C306.05,420.2 301.63,423.29 301.63,423.29 C301.63,423.29 298.57,430.33 298.57,430.33 C298.57,430.33 293.35,430.32 293.35,430.32 C293.35,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.72,417.16 306.72,417.16 C306.72,417.16 307.56,417.29 307.56,417.29 C307.56,417.29 307.59,417.33 307.59,417.33 C307.59,417.33 308.54,413.47 308.54,413.47 C308.54,413.47 306.71,408.22 306.71,408.22 C306.71,408.22 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.62,434.09 294.62,434.09 C294.62,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.8,420.3 305.8,420.3 C305.8,420.3 301.55,423.2 301.55,423.2 C301.55,423.2 298.74,430.31 298.74,430.31 C298.74,430.31 293.34,430.32 293.34,430.32 C293.34,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.32,418.77 306.32,418.77 C306.32,418.77 307.34,417.78 307.34,417.78 C307.34,417.78 307.74,418.52 307.74,418.52 C307.74,418.52 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.09 294.6,434.09 C294.6,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.98,420.3 305.98,420.3 C305.98,420.3 301.72,423.59 301.72,423.59 C301.72,423.59 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 296.68,421.72 296.68,421.72 C296.68,421.72 300.57,423.18 300.57,423.18 C300.57,423.18 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.41,419.97 306.41,419.97 C306.41,419.97 301.7,423.64 301.7,423.64 C301.7,423.64 298.69,430.31 298.69,430.31 C298.69,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 294.58,430.33 294.58,430.33 C294.58,430.33 298.38,430.31 298.38,430.31 C298.38,430.31 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.73,439.55 293.73,439.55 C293.73,439.55 298.46,439.54 298.46,439.54 C298.46,439.54 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.43,419.98 306.43,419.98 C306.43,419.98 301.75,423.57 301.75,423.57 C301.75,423.57 298.73,430.27 298.73,430.27 C298.73,430.27 293.72,430.3 293.72,430.3 C293.72,430.3 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.7,430.31 293.7,430.31 C293.7,430.31 298.74,430.26 298.74,430.26 C298.74,430.26 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z "
																keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0"
																calcMode="spline" />
															<clipPath id="_R_G_L_0_C_0_B">
																<path id="_R_G_L_0_C_0_P_0_B" fill-rule="nonzero" />
															</clipPath>
															<animate attributeType="XML" attributeName="opacity" dur="2s" from="0" to="1" xlink:href="#time_group_b" />
														</defs>
														<g id="_R_G_B">
															<g id="_R_G_L_1_G_B"
																transform=" translate(127.638, 127.945) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
																<g clip-path="url(#_R_G_L_1_C_0_B)">
																	<path id="_R_G_L_1_G_G_0_D_0_P_0_B" class="bpa-front-loader-cl-primary" fill-opacity="1"
																		fill-rule="nonzero"
																		d=" M328 398.61 C328,398.61 328,446.23 328,446.23 C328,449.7 325.2,452.5 321.75,452.5 C321.75,452.5 274.25,452.5 274.25,452.5 C270.8,452.5 268,449.7 268,446.23 C268,446.23 268,398.61 268,398.61 C268,395.15 270.8,392.35 274.25,392.35 C274.25,392.35 283.46,392.26 283.46,392.26 C283.46,392.26 283.46,390.38 283.46,390.38 C283.46,389.76 284.08,388.5 285.33,388.5 C286.58,388.5 287.21,389.75 287.21,390.38 C287.21,390.38 287.21,397.89 287.21,397.89 C287.21,398.53 286.59,399.78 285.33,399.78 C284.08,399.78 283.46,398.53 283.46,397.9 C283.46,397.9 283.46,396.02 283.46,396.02 C283.46,396.02 275.5,396.1 275.5,396.1 C273.43,396.1 271.75,397.79 271.75,399.86 C271.75,399.86 271.75,444.98 271.75,444.98 C271.75,447.06 273.43,448.74 275.5,448.74 C275.5,448.74 320.5,448.74 320.5,448.74 C322.57,448.74 324.25,447.06 324.25,444.98 C324.25,444.98 324.25,399.86 324.25,399.86 C324.25,397.79 322.57,396.1 320.5,396.1 C320.5,396.1 312.62,396.1 312.62,396.1 C312.62,396.1 312.63,397.06 312.63,397.99 C312.63,398.61 312,399.86 310.75,399.86 C309.5,399.86 308.88,398.61 308.88,397.98 C308.88,397.98 308.87,396.1 308.87,396.1 C308.87,396.1 301.88,396.1 301.88,396.1 C300.84,396.1 300,395.26 300,394.23 C300,393.19 300.84,392.35 301.88,392.35 C301.88,392.35 308.87,392.35 308.87,392.35 C308.87,392.35 308.87,390.47 308.87,390.47 C308.87,389.83 309.5,388.5 310.75,388.5 C312,388.5 312.62,389.84 312.62,390.47 C312.62,390.47 312.62,392.35 312.62,392.35 C312.62,392.35 321.75,392.35 321.75,392.35 C325.2,392.35 328,395.15 328,398.61z " />
																</g>
															</g>
															<g id="_R_G_L_0_G_B"
																transform=" translate(125.555, 126.412) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
																<g clip-path="url(#_R_G_L_0_C_0_B)">
																	<path id="_R_G_L_0_G_G_0_D_0_P_0_B" class="bpa-front-loader-cl-primary" fill-opacity="1"
																		fill-rule="nonzero"
																		d=" M305.86 420.29 C305.86,420.29 307.11,419.04 307.11,415.28 C307.11,409.01 303.36,407.76 298.36,407.76 C298.36,407.76 287.11,407.76 287.11,407.76 C287.11,407.76 287.11,434.08 287.11,434.08 C287.11,434.08 294.61,434.08 294.61,434.08 C294.61,434.08 294.61,441.6 294.61,441.6 C294.61,441.6 298.36,441.6 298.36,441.6 C298.36,441.6 298.36,434.08 298.36,434.08 C302.71,434.08 305.73,434.08 307.98,431.3 C309.07,429.95 309.62,428.24 309.61,426.5 C309.61,425.58 309.51,424.67 309.3,424.05 C308.73,422.65 308.36,421.55 305.86,420.29z  M302.11 430.32 C302.11,430.32 298.36,430.32 298.36,430.32 C298.36,430.32 298.36,426.56 298.36,426.56 C298.36,424.48 300.03,422.8 302.11,422.8 C304.13,422.8 305.86,424.43 305.86,426.56 C305.86,428.78 304.03,430.32 302.11,430.32z  M299.07 419.95 C298.43,420.26 297.82,420.63 297.26,421.05 C295.87,422.1 294.61,423.58 294.61,426.56 C294.61,426.56 294.61,430.32 294.61,430.32 C294.61,430.32 290.86,430.32 290.86,430.32 C290.86,430.32 290.86,411.52 290.86,411.52 C290.86,411.52 298.36,411.52 298.36,411.52 C301.35,411.52 303.36,412.77 303.36,415.28 C303.36,417.58 301.65,418.68 299.07,419.95z " />
																</g>
															</g>
														</g>
														<g id="time_group_b" />
													</svg>
												</div>
											</div>
                                            
                                            <v-date-picker mode="date" :min-date="jsCurrentDate" :max-date="booking_cal_maxdate"  ref="bkp_front_calendar_responsive" v-model="appointment_step_form_data.selected_date" @dayclick="dayClicked" :disabled-dates="[{start:new Date(jsCurrentDate), end: new Date(booking_cal_maxdate)}]" :available-dates="v_calendar_available_dates" @update:v-month-page="bpaMoveMonthResponsive" :first-day-of-week="first_day_of_week" :locale="site_locale" class="bpa-front-v-date-picker" :masks="{weekdays: 'W'}" v-if="isLoadDateTimeCalendarLoad != '1' && bookingpress_current_tab == 'datetime'" is-required :model-config="modelConfig"  />

                                        </div>
                                    </el-col>
                                    <el-col :xs="24" :sm="12" :md="12" :lg="12" :xl="12" v-if="displayResponsiveCalendar == '0'">
                                        <div class="bpa-front--dt__time-slots">
                                            <div class="bpa-front-loader-container" v-if="service_timing == '-1' && service_timing != 'null'">
                                                <div class="bpa-front-loader">
													<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid meet" width="256" height="256" viewBox="0 0 256 256" style="width:100%;height:100%">
														<defs>
															<animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_1_C_0_P_0" fill="freeze" attributeName="d" attributeType="XML" from="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z " to="M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z " keyTimes="0;0.5037594;0.5263158;0.5789474;0.6691729;0.6992481;0.7593985;0.7669173;1" values="M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M294.33 386.7 C294.33,386.7 291.96,386.7 291.96,386.7 C291.96,386.7 291.67,391.89 291.67,391.89 C291.67,391.89 292.41,396.34 292.41,396.34 C292.41,396.34 292.11,401.09 292.11,401.09 C292.11,401.09 295.67,401.09 295.67,401.09 C295.67,401.09 295.82,396.05 295.82,396.05 C295.82,396.05 295.97,391.75 295.97,391.75 C295.97,391.75 294.33,386.7 294.33,386.7z ;M303.49 386.7 C303.49,386.7 284.88,386.7 284.88,386.7 C284.88,386.7 284.88,402.72 284.88,402.72 C284.88,402.72 293.41,402.87 293.41,402.87 C293.41,402.87 293.07,405.24 293.07,405.24 C293.07,405.24 296.63,405.24 296.63,405.24 C296.63,405.24 296.82,402.57 296.82,402.57 C296.82,402.57 304.49,401.98 304.49,401.98 C304.49,401.98 303.49,386.7 303.49,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,398.12 265.56,398.12 C265.56,398.12 266.75,407.02 266.75,407.02 C266.75,407.02 294.78,405.83 294.78,405.83 C294.78,405.83 298.34,405.83 298.34,405.83 C298.34,405.83 332.75,406.72 332.75,406.72 C332.75,406.72 332.45,399.46 332.45,399.46 C332.45,399.46 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.56,442.32 265.56,442.32 C265.56,442.32 266.75,448.4 266.75,448.4 C266.75,448.4 283.8,447.51 283.8,447.51 C283.8,447.51 312.06,447.21 312.06,447.21 C312.06,447.21 332.75,448.1 332.75,448.1 C332.75,448.1 332.45,443.65 332.45,443.65 C332.45,443.65 330.97,386.7 330.97,386.7z ;M330.97 386.7 C330.97,386.7 263.64,386.7 263.64,386.7 C263.64,386.7 265.86,453.14 265.86,453.14 C265.86,453.14 276.98,456.11 276.98,456.11 C276.98,456.11 277.28,447.51 277.28,447.51 C277.28,447.51 319.47,447.81 319.47,447.81 C319.47,447.81 318.81,456.11 318.81,456.11 C318.81,456.11 329.63,454.92 329.63,454.92 C329.63,454.92 330.97,386.7 330.97,386.7z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.63,448.83 295.63,448.83 C295.63,448.83 295.71,448.75 295.71,448.75 C295.71,448.75 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z ;M330.93 386.68 C330.93,386.68 263.6,386.68 263.6,386.68 C263.6,386.68 265.82,453.13 265.82,453.13 C265.82,453.13 295.78,456.98 295.78,456.98 C295.78,456.98 295.89,452.83 295.89,452.83 C295.89,452.83 296.26,452.98 296.26,452.98 C296.26,452.98 295.78,457.13 295.78,457.13 C295.78,457.13 329.59,454.91 329.59,454.91 C329.59,454.91 330.93,386.68 330.93,386.68z " keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0" calcMode="spline"/>
															<clipPath id="_R_G_L_1_C_0">
																<path id="_R_G_L_1_C_0_P_0" fill-rule="nonzero"/>
															</clipPath>
															<animate repeatCount="indefinite" dur="2.2166667s" begin="0s" xlink:href="#_R_G_L_0_C_0_P_0" fill="freeze" attributeName="d" attributeType="XML" from="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z " to="M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z " keyTimes="0;0.1804511;0.2180451;0.2481203;0.2631579;0.2706767;0.2781955;0.2857143;0.3157895;0.3308271;0.3533835;0.3834586;0.406015;0.4135338;0.4210526;0.4511278;0.4736842;0.4887218;0.4962406;1" values="M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M306.79 419.97 C306.79,419.97 306.83,419.98 306.83,419.98 C306.83,419.98 306.8,419.97 306.8,419.97 C306.8,419.97 306.78,420 306.78,420 C306.78,420 306.8,420 306.8,420 C306.8,420 306.86,420 306.86,420 C306.86,420 306.95,419.93 306.95,419.93 C306.95,419.93 306.86,419.96 306.86,419.96 C306.86,419.96 306.84,420.21 306.84,420.21 C306.84,420.21 306.89,420.1 306.89,420.1 C306.89,420.1 306.83,420.1 306.83,420.1 C306.83,420.1 306.5,420.99 306.83,420.17 C307.17,419.36 306.69,420.75 306.69,419.9 C306.69,419.04 306.89,420.14 306.89,420.14 C306.89,420.14 306.93,420.01 306.93,420.01 C306.93,420.01 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 302.88,423.24 302.88,423.24 C302.88,423.24 302.6,423.2 302.6,423.2 C302.6,423.2 302.79,423.22 302.79,423.22 C302.79,423.22 302.47,423.18 302.47,423.18 C302.47,423.18 302.62,423.19 302.62,423.19 C302.62,423.19 302.53,423.17 302.53,423.17 C302.53,423.17 302.43,423.36 302.43,423.18 C302.43,422.99 302.57,423.16 302.57,423.16 C302.57,423.16 302.4,423.16 302.4,423.16 C302.4,423.16 302.71,423.1 302.71,423.1 C302.71,423.1 302.68,423.07 302.68,423.07 C302.68,423.07 302.76,423.09 302.76,423.09 C302.76,423.09 302.66,423.2 302.66,423.2 C302.66,423.2 302.71,423.14 302.71,423.14 C302.71,423.14 302.75,423.12 302.75,423.12 C302.75,423.12 302.75,423.18 302.75,423.18 C302.75,423.18 302.53,423.22 302.53,423.22 C302.53,423.22 306.79,419.98 306.79,419.98 C306.79,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.8,419.98 306.8,419.98 C306.8,419.98 306.77,419.98 306.77,419.98 C306.77,419.98 306.79,419.98 306.79,419.98 C306.79,419.98 306.79,419.97 306.79,419.97z ;M310.92 429.74 C310.92,429.74 310.97,429.75 310.97,429.75 C310.97,429.75 310.93,429.74 310.93,429.74 C310.93,429.74 310.91,429.77 310.91,429.77 C310.91,429.77 310.94,429.77 310.94,429.77 C310.94,429.77 310.99,429.77 310.99,429.77 C310.99,429.77 311.09,429.7 311.09,429.7 C311.09,429.7 310.99,429.73 310.99,429.73 C310.99,429.73 310.9,434.91 310.9,434.91 C310.9,434.91 312.25,433.8 312.25,433.8 C312.25,433.8 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 303.93,428.18 303.93,428.18 C303.93,428.18 303.66,428.14 303.66,428.14 C303.66,428.14 303.84,428.16 303.84,428.16 C303.84,428.16 303.52,428.11 303.52,428.11 C303.52,428.11 303.67,428.12 303.67,428.12 C303.67,428.12 303.58,428.1 303.58,428.1 C303.58,428.1 303.49,428.3 303.49,428.11 C303.49,427.93 303.63,428.09 303.63,428.09 C303.63,428.09 303.45,428.1 303.45,428.1 C303.45,428.1 303.76,428.04 303.76,428.04 C303.76,428.04 303.73,428 303.73,428 C303.73,428 303.69,427.98 303.69,427.98 C303.69,427.98 303.71,428.13 303.71,428.13 C303.71,428.13 303.76,428.08 303.76,428.08 C303.76,428.08 303.8,428.06 303.8,428.06 C303.8,428.06 303.8,428.11 303.8,428.11 C303.8,428.11 303.58,428.16 303.58,428.16 C303.58,428.16 310.92,429.75 310.92,429.75 C310.92,429.75 310.91,429.75 310.91,429.75 C310.91,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.9,429.75 310.9,429.75 C310.9,429.75 310.93,429.75 310.93,429.75 C310.93,429.75 310.92,429.74 310.92,429.74z ;M299.65 434.12 C299.65,434.12 299.7,434.13 299.7,434.13 C299.7,434.13 299.66,434.11 299.66,434.11 C299.66,434.11 299.64,434.14 299.64,434.14 C299.64,434.14 299.66,434.14 299.66,434.14 C299.66,434.14 299.72,434.15 299.72,434.15 C299.72,434.15 299.81,434.08 299.81,434.08 C299.81,434.08 299.72,434.11 299.72,434.11 C299.72,434.11 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 300.06,430.31 300.06,430.31 C300.06,430.31 299.78,430.27 299.78,430.27 C299.78,430.27 299.96,430.29 299.96,430.29 C299.96,430.29 299.65,430.25 299.65,430.25 C299.65,430.25 299.8,430.25 299.8,430.25 C299.8,430.25 299.7,430.24 299.7,430.24 C299.7,430.24 299.61,430.43 299.61,430.25 C299.61,430.06 299.75,430.22 299.75,430.22 C299.75,430.22 299.57,430.23 299.57,430.23 C299.57,430.23 299.89,430.17 299.89,430.17 C299.89,430.17 299.85,430.13 299.85,430.13 C299.85,430.13 299.82,430.12 299.82,430.12 C299.82,430.12 299.83,430.26 299.83,430.26 C299.83,430.26 299.89,430.21 299.89,430.21 C299.89,430.21 299.93,430.19 299.93,430.19 C299.93,430.19 299.93,430.25 299.93,430.25 C299.93,430.25 299.7,430.29 299.7,430.29 C299.7,430.29 299.65,434.13 299.65,434.13 C299.65,434.13 299.64,434.13 299.64,434.13 C299.64,434.13 299.66,434.13 299.66,434.13 C299.66,434.13 299.63,434.13 299.63,434.13 C299.63,434.13 299.65,434.13 299.65,434.13 C299.65,434.13 299.65,434.12 299.65,434.12z ;M292.83 434.12 C292.83,434.12 292.81,434.11 292.81,434.11 C292.81,434.11 292.84,434.12 292.84,434.12 C292.84,434.12 292.82,434.15 292.82,434.15 C292.82,434.15 292.85,434.15 292.85,434.15 C292.85,434.15 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 292.89,430.31 292.89,430.31 C292.89,430.31 292.69,430.25 292.69,430.25 C292.69,430.25 292.72,430.28 292.72,430.28 C292.72,430.28 292.63,430.26 292.63,430.26 C292.63,430.26 292.65,430.43 292.65,430.25 C292.65,430.06 292.56,430.15 292.56,430.15 C292.56,430.15 292.61,430.23 292.61,430.23 C292.61,430.23 292.93,430.17 292.93,430.17 C292.93,430.17 292.89,430.13 292.89,430.13 C292.89,430.13 292.85,430.12 292.85,430.12 C292.85,430.12 292.87,430.26 292.87,430.26 C292.87,430.26 292.93,430.21 292.93,430.21 C292.93,430.21 292.96,430.19 292.96,430.19 C292.96,430.19 292.96,430.25 292.96,430.25 C292.96,430.25 292.77,430.22 292.77,430.22 C292.77,430.22 292.83,434.13 292.83,434.13 C292.83,434.13 292.82,434.13 292.82,434.13 C292.82,434.13 292.84,434.13 292.84,434.13 C292.84,434.13 292.81,434.13 292.81,434.13 C292.81,434.13 292.83,434.13 292.83,434.13 C292.83,434.13 292.83,434.12 292.83,434.12z ;M286.91 434.04 C286.91,434.04 286.89,434.02 286.89,434.02 C286.89,434.02 286.92,434.03 286.92,434.03 C286.92,434.03 286.9,434.06 286.9,434.06 C286.9,434.06 286.92,434.06 286.92,434.06 C286.92,434.06 294.61,434.08 294.61,434.08 C294.61,434.08 298.39,434.03 298.39,434.03 C298.39,434.03 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.47,430.31 298.47,430.31 C298.47,430.31 294.44,430.33 294.44,430.33 C294.44,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.91,428.68 291.91,428.68 C291.91,428.68 291.82,428.67 291.82,428.67 C291.82,428.67 291.88,428.65 291.88,428.46 C291.88,428.28 291.78,428.37 291.78,428.37 C291.78,428.37 291.84,428.44 291.84,428.44 C291.84,428.44 292.15,428.39 292.15,428.39 C292.15,428.39 292.12,428.35 292.12,428.35 C292.12,428.35 292.08,428.33 292.08,428.33 C292.08,428.33 292.1,428.48 292.1,428.48 C292.1,428.48 292.15,428.42 292.15,428.42 C292.15,428.42 292.19,428.41 292.19,428.41 C292.19,428.41 292.19,428.46 292.19,428.46 C292.19,428.46 291.97,428.51 291.97,428.51 C291.97,428.51 287.14,434.07 287.14,434.07 C287.14,434.07 286.89,434.05 286.89,434.05 C286.89,434.05 286.92,434.05 286.92,434.05 C286.92,434.05 286.89,434.05 286.89,434.05 C286.89,434.05 286.91,434.05 286.91,434.05 C286.91,434.05 286.91,434.04 286.91,434.04z ;M286.7 429.47 C286.7,429.47 286.88,429.37 286.88,429.37 C286.88,429.37 286.52,429.45 286.52,429.45 C286.52,429.45 286.83,429.85 286.83,429.85 C286.83,429.85 286.14,434.18 286.14,434.18 C286.14,434.18 294.61,434.08 294.61,434.08 C294.61,434.08 298.37,434.08 298.37,434.08 C298.37,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.38,430.31 298.38,430.31 C298.38,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 291.99,426.42 291.99,426.42 C291.99,426.42 291.87,426.34 291.87,426.34 C291.87,426.34 292.01,426.25 292.01,426.07 C292.01,425.88 292.05,425.99 292.05,425.99 C292.05,425.99 291.97,425.95 291.97,425.95 C291.97,425.95 292.39,425.98 292.39,425.98 C292.39,425.98 292.27,426.05 292.27,426.05 C292.27,426.05 292.35,425.99 292.35,425.99 C292.35,425.99 292.32,426 292.32,426 C292.32,426 292.4,426 292.4,426 C292.4,426 292.4,426.06 292.4,426.06 C292.4,426.06 292.39,426.05 292.39,426.05 C292.39,426.05 292.62,426.45 292.62,426.45 C292.62,426.45 286.78,429.41 286.78,429.41 C286.78,429.41 286.55,429.2 286.55,429.2 C286.55,429.2 286.62,429.38 286.62,429.38 C286.62,429.38 286.51,429.44 286.51,429.44 C286.51,429.44 286.46,429.37 286.46,429.37 C286.46,429.37 286.7,429.47 286.7,429.47z ;M286.5 424.9 C286.5,424.9 286.87,424.72 286.87,424.72 C286.87,424.72 286.13,424.87 286.13,424.87 C286.13,424.87 286.76,425.64 286.76,425.64 C286.76,425.64 285.37,434.3 285.37,434.3 C285.37,434.3 294.63,434.09 294.63,434.09 C294.63,434.09 298.37,434.09 298.37,434.09 C298.37,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.36,430.31 298.36,430.31 C298.36,430.31 294.59,430.33 294.59,430.33 C294.59,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.06,424.16 292.06,424.16 C292.06,424.16 291.91,424.01 291.91,424.01 C291.91,424.01 292.13,423.86 292.13,423.68 C292.13,423.49 292.32,423.6 292.32,423.6 C292.32,423.6 292.1,423.46 292.1,423.46 C292.1,423.46 292.62,423.57 292.62,423.57 C292.62,423.57 292.43,423.75 292.43,423.75 C292.43,423.75 292.62,423.64 292.62,423.64 C292.62,423.64 292.54,423.53 292.54,423.53 C292.54,423.53 292.65,423.57 292.65,423.57 C292.65,423.57 292.62,423.72 292.62,423.72 C292.62,423.72 292.58,423.64 292.58,423.64 C292.58,423.64 293.27,424.39 293.27,424.39 C293.27,424.39 286.43,424.75 286.43,424.75 C286.43,424.75 286.2,424.35 286.2,424.35 C286.2,424.35 286.31,424.72 286.31,424.72 C286.31,424.72 286.13,424.83 286.13,424.83 C286.13,424.83 286.02,424.68 286.02,424.68 C286.02,424.68 286.5,424.9 286.5,424.9z ;M285.53 417.93 C285.53,417.93 285.61,418.01 285.61,418.01 C285.61,418.01 285.39,417.97 285.39,417.97 C285.39,417.97 285.68,418.12 285.68,418.12 C285.68,418.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.38,434.11 298.38,434.11 C298.38,434.11 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.71,430.31 298.71,430.31 C298.71,430.31 293.3,430.31 293.3,430.31 C293.3,430.31 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.26,417.75 291.26,417.56 C291.26,417.38 291.34,417.38 291.34,417.38 C291.34,417.38 291.45,417.54 291.45,417.54 C291.45,417.54 291.21,417.5 291.21,417.5 C291.21,417.5 291.32,417.45 291.32,417.45 C291.32,417.45 291.28,417.51 291.28,417.51 C291.28,417.51 291.5,417.56 291.5,417.56 C291.5,417.56 291.52,417.54 291.52,417.54 C291.52,417.54 291.45,417.6 291.45,417.6 C291.45,417.6 291.43,417.67 291.43,417.67 C291.43,417.67 291.41,417.89 291.41,417.89 C291.41,417.89 291.24,417.95 291.24,417.95 C291.24,417.95 285.98,417.86 285.98,417.86 C285.98,417.86 286.02,417.69 286.02,417.69 C286.02,417.69 285.92,417.77 285.92,417.77 C285.92,417.77 285.81,417.62 285.81,417.62 C285.81,417.62 285.53,417.93 285.53,417.93z ;M284.93 404.18 C284.93,404.18 281.14,411.97 281.14,411.97 C281.14,411.97 273.88,412.04 273.88,412.04 C273.88,412.04 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.08 298.36,434.08 C298.36,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.35,430.31 298.35,430.31 C298.35,430.31 294.59,430.32 294.59,430.32 C294.59,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 291.91,415.81 291.91,415.81 C291.91,415.81 291.8,415.82 291.8,415.82 C291.8,415.82 291.88,415.73 291.88,415.73 C291.88,415.73 291.9,415.66 291.9,415.66 C291.9,415.66 291.8,415.65 291.8,415.65 C291.8,415.65 291.73,415.73 291.73,415.73 C291.73,415.73 291.87,415.58 291.87,415.58 C291.87,415.58 291.87,415.71 291.87,415.71 C291.87,415.71 291.83,415.72 291.83,415.72 C291.83,415.72 291.82,415.71 291.82,415.71 C291.82,415.71 291.66,414.92 291.66,414.92 C291.66,414.92 291.45,413.38 291.45,413.38 C291.45,413.38 291.09,411.81 291.09,411.81 C291.09,411.81 291.05,411.77 291.05,411.77 C291.05,411.77 289.08,410.26 289.08,410.26 C289.08,410.26 284.93,404.18 284.93,404.18z ;M298.66 404.21 C298.66,404.21 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.76,430.32 298.76,430.32 C298.76,430.32 294.62,430.33 294.62,430.33 C294.62,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 300.75,413.19 300.75,413.19 C300.75,413.19 300.74,413.2 300.74,413.2 C300.74,413.2 300.68,413.28 300.68,413.28 C300.68,413.28 300.74,413.15 300.74,413.15 C300.74,413.15 300.76,413.19 300.76,413.19 C300.76,413.19 300.77,413.17 300.77,413.17 C300.77,413.17 303.55,406.44 303.55,406.44 C303.55,406.44 302.85,404.47 302.85,404.47 C302.85,404.47 301.29,403.47 301.29,403.47 C301.29,403.47 301.18,403.32 301.18,403.32 C301.18,403.32 298.66,404.21 298.66,404.21z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.07 294.61,434.07 C294.61,434.07 298.36,434.07 298.36,434.07 C298.36,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 307.04,419.79 307.04,419.79 C307.04,419.79 301.92,423.68 301.92,423.68 C301.92,423.68 298.73,430.31 298.73,430.31 C298.73,430.31 293.3,430.33 293.3,430.33 C293.3,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.59,416.02 302.59,416.02 C302.59,416.02 302.55,415.98 302.55,415.98 C302.55,415.98 302.63,415.99 302.63,415.99 C302.63,415.99 306.67,409.55 306.67,409.55 C306.67,409.55 306.65,409.61 306.65,409.61 C306.65,409.61 306.59,409.55 306.59,409.55 C306.59,409.55 306.69,409.72 306.69,409.72 C306.69,409.72 306.58,409.57 306.58,409.57 C306.58,409.57 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.09 294.61,434.09 C294.61,434.09 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.29,420.1 306.29,420.1 C306.29,420.1 301.7,423.39 301.7,423.39 C301.7,423.39 298.38,430.31 298.38,430.31 C298.38,430.31 293.4,430.32 293.4,430.32 C293.4,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 302.63,417.02 302.63,417.02 C302.63,417.02 302.61,416.97 302.61,416.97 C302.61,416.97 302.63,416.9 302.63,416.9 C302.63,416.9 307.12,415.55 307.12,415.55 C307.12,415.55 307.51,415.47 307.51,415.47 C307.51,415.47 307.52,415.47 307.52,415.47 C307.52,415.47 309.01,412.56 309.01,412.56 C309.01,412.56 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.08 294.6,434.08 C294.6,434.08 298.37,434.07 298.37,434.07 C298.37,434.07 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.05,420.2 306.05,420.2 C306.05,420.2 301.63,423.29 301.63,423.29 C301.63,423.29 298.57,430.33 298.57,430.33 C298.57,430.33 293.35,430.32 293.35,430.32 C293.35,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.72,417.16 306.72,417.16 C306.72,417.16 307.56,417.29 307.56,417.29 C307.56,417.29 307.59,417.33 307.59,417.33 C307.59,417.33 308.54,413.47 308.54,413.47 C308.54,413.47 306.71,408.22 306.71,408.22 C306.71,408.22 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.62,434.09 294.62,434.09 C294.62,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.8,420.3 305.8,420.3 C305.8,420.3 301.55,423.2 301.55,423.2 C301.55,423.2 298.74,430.31 298.74,430.31 C298.74,430.31 293.34,430.32 293.34,430.32 C293.34,430.32 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 300.2,418.16 300.2,418.16 C300.2,418.16 306.32,418.77 306.32,418.77 C306.32,418.77 307.34,417.78 307.34,417.78 C307.34,417.78 307.74,418.52 307.74,418.52 C307.74,418.52 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.6,434.09 294.6,434.09 C294.6,434.09 298.35,434.08 298.35,434.08 C298.35,434.08 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 305.98,420.3 305.98,420.3 C305.98,420.3 301.72,423.59 301.72,423.59 C301.72,423.59 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 297.55,418.67 297.55,418.67 C297.55,418.67 296.68,421.72 296.68,421.72 C296.68,421.72 300.57,423.18 300.57,423.18 C300.57,423.18 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 294.61,434.08 294.61,434.08 C294.61,434.08 298.36,434.09 298.36,434.09 C298.36,434.09 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.41,419.97 306.41,419.97 C306.41,419.97 301.7,423.64 301.7,423.64 C301.7,423.64 298.69,430.31 298.69,430.31 C298.69,430.31 294.56,430.33 294.56,430.33 C294.56,430.33 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 294.58,430.33 294.58,430.33 C294.58,430.33 298.38,430.31 298.38,430.31 C298.38,430.31 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.73,439.55 293.73,439.55 C293.73,439.55 298.46,439.54 298.46,439.54 C298.46,439.54 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.43,419.98 306.43,419.98 C306.43,419.98 301.75,423.57 301.75,423.57 C301.75,423.57 298.73,430.27 298.73,430.27 C298.73,430.27 293.72,430.3 293.72,430.3 C293.72,430.3 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.7,430.31 293.7,430.31 C293.7,430.31 298.74,430.26 298.74,430.26 C298.74,430.26 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z ;M301.92 404.95 C301.92,404.95 293.25,405.03 293.25,405.03 C293.25,405.03 285.98,405.1 285.98,405.1 C285.98,405.1 284.05,419.12 284.05,419.12 C284.05,419.12 285.37,434.3 285.37,434.3 C285.37,434.3 293.25,442.25 293.25,442.25 C293.25,442.25 298.5,442.3 298.5,442.3 C298.5,442.3 299.74,434.68 299.74,434.68 C299.74,434.68 303.69,434.6 303.69,434.6 C303.69,434.6 306.59,433.87 306.59,433.87 C306.59,433.87 311.49,430.09 311.49,430.09 C311.49,430.09 310.52,426.16 310.86,425.35 C311.19,424.53 310.82,424.83 310.82,423.97 C310.82,423.12 310.56,422.53 310.56,422.53 C310.56,422.53 308.71,419.49 308.71,419.49 C308.71,419.49 306.45,419.99 306.45,419.99 C306.45,419.99 301.77,423.53 301.77,423.53 C301.77,423.53 298.75,430.25 298.75,430.25 C298.75,430.25 293.3,430.28 293.3,430.28 C293.3,430.28 293.04,430.16 293.04,430.16 C293.04,430.16 291.91,428.46 291.91,428.46 C291.91,428.46 292.21,418.97 292.21,418.97 C292.21,418.97 291.95,418.04 291.95,418.04 C291.95,418.04 291.91,416.23 291.91,416.04 C291.91,415.86 292.25,414.59 292.25,414.59 C292.25,414.59 293.88,413.41 293.88,413.41 C293.88,413.41 294.99,412.85 294.99,412.85 C294.99,412.85 297.18,412.81 297.18,412.81 C297.18,412.81 299.59,413 299.59,413 C299.59,413 301.89,414.22 301.89,414.22 C301.89,414.22 302.37,415.82 302.37,415.82 C302.37,415.82 301.74,416.82 301.74,416.82 C301.74,416.82 292.58,424.16 292.58,424.16 C292.58,424.16 293.3,430.28 293.3,430.28 C293.3,430.28 298.75,430.25 298.75,430.25 C298.75,430.25 301.74,423.57 301.74,423.57 C301.74,423.57 306.45,419.97 306.45,419.97 C306.45,419.97 308.08,414.37 308.08,414.37 C308.08,414.37 310.3,409.7 310.3,409.7 C310.3,409.7 301.92,404.95 301.92,404.95z " keySplines="0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0.167 0.167 0.833 0.833;0 0 0 0" calcMode="spline"/>
															<clipPath id="_R_G_L_0_C_0">
																<path id="_R_G_L_0_C_0_P_0" fill-rule="nonzero"/>
															</clipPath>
															<animate attributeType="XML" attributeName="opacity" dur="2s" from="0" to="1" xlink:href="#time_group"/>
														</defs>
														<g id="_R_G">
															<g id="_R_G_L_1_G" transform=" translate(127.638, 127.945) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
																<g clip-path="url(#_R_G_L_1_C_0)">
																	<path id="_R_G_L_1_G_G_0_D_0_P_0" class="bpa-front-loader-cl-primary" fill-opacity="1" fill-rule="nonzero" d=" M328 398.61 C328,398.61 328,446.23 328,446.23 C328,449.7 325.2,452.5 321.75,452.5 C321.75,452.5 274.25,452.5 274.25,452.5 C270.8,452.5 268,449.7 268,446.23 C268,446.23 268,398.61 268,398.61 C268,395.15 270.8,392.35 274.25,392.35 C274.25,392.35 283.46,392.26 283.46,392.26 C283.46,392.26 283.46,390.38 283.46,390.38 C283.46,389.76 284.08,388.5 285.33,388.5 C286.58,388.5 287.21,389.75 287.21,390.38 C287.21,390.38 287.21,397.89 287.21,397.89 C287.21,398.53 286.59,399.78 285.33,399.78 C284.08,399.78 283.46,398.53 283.46,397.9 C283.46,397.9 283.46,396.02 283.46,396.02 C283.46,396.02 275.5,396.1 275.5,396.1 C273.43,396.1 271.75,397.79 271.75,399.86 C271.75,399.86 271.75,444.98 271.75,444.98 C271.75,447.06 273.43,448.74 275.5,448.74 C275.5,448.74 320.5,448.74 320.5,448.74 C322.57,448.74 324.25,447.06 324.25,444.98 C324.25,444.98 324.25,399.86 324.25,399.86 C324.25,397.79 322.57,396.1 320.5,396.1 C320.5,396.1 312.62,396.1 312.62,396.1 C312.62,396.1 312.63,397.06 312.63,397.99 C312.63,398.61 312,399.86 310.75,399.86 C309.5,399.86 308.88,398.61 308.88,397.98 C308.88,397.98 308.87,396.1 308.87,396.1 C308.87,396.1 301.88,396.1 301.88,396.1 C300.84,396.1 300,395.26 300,394.23 C300,393.19 300.84,392.35 301.88,392.35 C301.88,392.35 308.87,392.35 308.87,392.35 C308.87,392.35 308.87,390.47 308.87,390.47 C308.87,389.83 309.5,388.5 310.75,388.5 C312,388.5 312.62,389.84 312.62,390.47 C312.62,390.47 312.62,392.35 312.62,392.35 C312.62,392.35 321.75,392.35 321.75,392.35 C325.2,392.35 328,395.15 328,398.61z "/>
																</g>
															</g>
															<g id="_R_G_L_0_G" transform=" translate(125.555, 126.412) scale(3.37139, 3.37139) translate(-297.638, -420.945)">
																<g clip-path="url(#_R_G_L_0_C_0)">
																	<path id="_R_G_L_0_G_G_0_D_0_P_0" class="bpa-front-loader-cl-primary" fill-opacity="1" fill-rule="nonzero" d=" M305.86 420.29 C305.86,420.29 307.11,419.04 307.11,415.28 C307.11,409.01 303.36,407.76 298.36,407.76 C298.36,407.76 287.11,407.76 287.11,407.76 C287.11,407.76 287.11,434.08 287.11,434.08 C287.11,434.08 294.61,434.08 294.61,434.08 C294.61,434.08 294.61,441.6 294.61,441.6 C294.61,441.6 298.36,441.6 298.36,441.6 C298.36,441.6 298.36,434.08 298.36,434.08 C302.71,434.08 305.73,434.08 307.98,431.3 C309.07,429.95 309.62,428.24 309.61,426.5 C309.61,425.58 309.51,424.67 309.3,424.05 C308.73,422.65 308.36,421.55 305.86,420.29z  M302.11 430.32 C302.11,430.32 298.36,430.32 298.36,430.32 C298.36,430.32 298.36,426.56 298.36,426.56 C298.36,424.48 300.03,422.8 302.11,422.8 C304.13,422.8 305.86,424.43 305.86,426.56 C305.86,428.78 304.03,430.32 302.11,430.32z  M299.07 419.95 C298.43,420.26 297.82,420.63 297.26,421.05 C295.87,422.1 294.61,423.58 294.61,426.56 C294.61,426.56 294.61,430.32 294.61,430.32 C294.61,430.32 290.86,430.32 290.86,430.32 C290.86,430.32 290.86,411.52 290.86,411.52 C290.86,411.52 298.36,411.52 298.36,411.52 C301.35,411.52 303.36,412.77 303.36,415.28 C303.36,417.58 301.65,418.68 299.07,419.95z "/>
																</g>
															</g>
														</g>
														<g id="time_group"/>
													</svg>
												</div>
                                            </div>
                                            <div class="bpa-front--dt__ts-sm-back-btn">
                                                <el-button class="bpa-front-btn" @click="displayCalendar">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M19 4h-1V3c0-.55-.45-1-1-1s-1 .45-1 1v1H8V3c0-.55-.45-1-1-1s-1 .45-1 1v1H5c-1.11 0-1.99.9-1.99 2L3 20c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 15c0 .55-.45 1-1 1H6c-.55 0-1-.45-1-1V9h14v10zM7 11h2v2H7zm4 0h2v2h-2zm4 0h2v2h-2z"/></svg>
                                                    <label> {{ appointment_step_form_data.selected_date | bookingpress_format_date }} </label>
                                                </el-button>
                                            </div>
                                            <div class="bpa-front--dt__ts-heading">                                                
                                                <div class="bpa-front-module-heading"><?php echo esc_html($bookingpress_timeslot_title); ?></div>
                                            </div>                                            
                                            <div class="bpa-front--dt__ts-body bpa-front__no-timeslots-body" v-if="no_timeslot_available != '' && no_timeslot_available == true">
                                                <svg viewBox="0 0 120 121" xmlns="http://www.w3.org/2000/svg">
                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                        d="M108.486 103.08C101.042 112.139 86.7296 109.719 75.3575 112.572C64.3105 115.344 53.4388 123.192 42.6284 119.606C31.8342 116.026 27.8283 103.242 20.6455 94.4249C13.5882 85.7617 2.04617 79.3615 0.797986 68.2575C-0.448903 57.1649 8.61128 47.9531 14.3452 38.376C19.5416 29.6967 24.6347 21.093 32.6953 14.9808C41.3289 8.43396 51.0768 2.35675 61.9118 2.30667C72.8285 2.25621 82.086 9.1904 91.5052 14.709C101.484 20.5552 114.441 24.5839 118.451 35.4317C122.456 46.2671 113.129 57.2263 111.445 68.6549C109.732 80.2849 115.949 93.9976 108.486 103.08Z"
                                                        class="bpa-front-dev__panel-bg" />
                                                    <g filter="url(#filter0_d_4344_13430)">
                                                        <rect x="16.3105" y="27.8936" width="95.3718" height="22.2173" rx="11.1086"
                                                            class="bpa-front-dev__form-bg" />
                                                    </g>
                                                    <circle cx="27.1474" cy="39.0009" r="5.41885" class="bpa-front-dev__primary-bg" />
                                                    <rect x="37.9863" y="39.542" width="41.1833" height="2.16754" rx="1.08377" fill="#F4F7FB" />
                                                    <rect x="37.9863" y="36.0215" width="13.5471" height="2.16754" rx="1.08377" fill="#F4F7FB" />
                                                    <rect x="53.4297" y="36.0215" width="25.7395" height="2.16754" rx="1.08377" fill="#F4F7FB" />
                                                    <rect x="84.5859" y="34.9375" width="21.6754" height="8.12828" rx="4" fill="#F4F7FB" />
                                                    <g filter="url(#filter1_d_4344_13430)">
                                                        <rect x="16.3105" y="54.1748" width="95.3718" height="22.2173" rx="11.1086"
                                                            class="bpa-front-dev__form-bg" />
                                                    </g>
                                                    <circle cx="27.1474" cy="65.2831" r="5.41885" fill="#E8ECF5" />
                                                    <rect x="37.9863" y="65.8252" width="41.1833" height="2.16754" rx="1.08377" fill="#E8ECF5" />
                                                    <rect x="37.9863" y="62.3037" width="13.5471" height="2.16754" rx="1.08377" fill="#DDE1ED" />
                                                    <rect x="53.4297" y="62.3037" width="25.7395" height="2.16754" rx="1.08377" fill="#E8ECF5" />
                                                    <rect x="84.5859" y="61.2197" width="21.6754" height="8.12828" rx="4" fill="#F4F7FB" />
                                                    <g filter="url(#filter2_d_4344_13430)">
                                                        <rect x="16.3105" y="80.4541" width="95.3718" height="22.2173" rx="11.1086"
                                                            class="bpa-front-dev__form-bg" />
                                                    </g>
                                                    <circle cx="27.1474" cy="91.5644" r="5.41885" fill="#E8ECF5" />
                                                    <rect x="37.9863" y="92.1064" width="41.1833" height="2.16754" rx="1.08377" fill="#E8ECF5" />
                                                    <rect x="37.9863" y="88.582" width="13.5471" height="2.16754" rx="1.08377" fill="#DDE1ED" />
                                                    <rect x="53.4297" y="88.582" width="25.7395" height="2.16754" rx="1.08377" fill="#E8ECF5" />
                                                    <rect x="84.5859" y="87.499" width="21.6754" height="8.12828" rx="4" class="bpa-front-dev__primary-bg" />
                                                    <path
                                                        d="M10.6699 62.6393C11.3924 62.6393 11.6694 61.9455 11.7176 61.5986C11.7176 62.3164 12.4642 62.6058 12.8375 62.6537C11.9704 62.6537 11.7296 63.3953 11.7176 63.7662C11.7176 62.9623 11.0191 62.6752 10.6699 62.6393Z"
                                                        stroke="#F4B125" stroke-opacity="0.6" stroke-linejoin="round" />
                                                    <line x1="11.4707" y1="60.4463" x2="11.4707" y2="60.3625" stroke="#F4B125" stroke-opacity="0.6"
                                                        stroke-linecap="round" />
                                                    <line x1="11.4707" y1="65.8652" x2="11.4707" y2="65.1312" stroke="#F4B125" stroke-opacity="0.6"
                                                        stroke-linecap="round" />
                                                    <path d="M13.4863 62.709H14.7869" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round" />
                                                    <path d="M8.7207 62.709H9.53353" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round" />
                                                    <path
                                                        d="M10.3483 40.076L10.35 40.0813H10.3556L10.3511 40.0846L10.3528 40.0898L10.3483 40.0866L10.3438 40.0898L10.3455 40.0846L10.3411 40.0813H10.3466L10.3483 40.076Z"
                                                        class="bpa-front-dev__primary-bg" />
                                                    <path
                                                        d="M117.915 48.4764L117.916 48.4817H117.922L117.917 48.485L117.919 48.4902L117.915 48.487L117.91 48.4902L117.912 48.485L117.907 48.4817H117.913L117.915 48.4764Z"
                                                        class="bpa-front-dev__primary-bg" />
                                                    <path
                                                        d="M84.5866 111.606L84.5883 111.612H84.5938L84.5894 111.615L84.5911 111.62L84.5866 111.617L84.5821 111.62L84.5838 111.615L84.5793 111.612H84.5849L84.5866 111.606Z"
                                                        stroke="#F5AE41" />
                                                    <circle cx="56.1379" cy="1.88181" r="0.854713" stroke="#EE2445" stroke-opacity="0.7" />
                                                    <circle cx="111.681" cy="79.0998" r="0.854713" stroke="#EE2445" stroke-opacity="0.6" />
                                                    <circle cx="2.76292" cy="79.0993" r="0.854713" stroke="#EE2445" stroke-opacity="0.6" />
                                                    <circle cx="69.9579" cy="15.9723" r="0.541885" fill="#2166F1" />
                                                    <line x1="43.9062" y1="16.5115" x2="43.9062" y2="20.0337" stroke="#01CB62" stroke-opacity="0.3" />
                                                    <line x1="45.3027" y1="18.6365" x2="41.7805" y2="18.6365" stroke="#01CB62" stroke-opacity="0.3" />
                                                    <line x1="21.3262" y1="105.778" x2="61.9479" y2="105.778" stroke="#DCE4F5" stroke-width="3"
                                                        stroke-linecap="round" />
                                                    <line x1="69.0176" y1="105.778" x2="87.9639" y2="105.778" stroke="#DCE4F5" stroke-width="3"
                                                        stroke-linecap="round" />
                                                    <line x1="95.8379" y1="105.778" x2="114.784" y2="105.778" stroke="#DCE4F5" stroke-width="3"
                                                        stroke-linecap="round" />
                                                    <path
                                                        d="M92.9902 15.9169C93.8934 15.9169 94.2396 15.0496 94.2998 14.616C94.2998 15.5131 95.233 15.875 95.6997 15.9348C94.6159 15.9348 94.3148 16.8619 94.2998 17.3254C94.2998 16.3206 93.4268 15.9617 92.9902 15.9169Z"
                                                        stroke="#F4B125" stroke-linejoin="round" />
                                                    <line x1="94.1113" y1="13.3025" x2="94.1113" y2="12.9478" stroke="#F4B125" stroke-linecap="round" />
                                                    <line x1="94.1113" y1="20.0769" x2="94.1113" y2="18.9094" stroke="#F4B125" stroke-linecap="round" />
                                                    <path d="M96.5098 16.0056H98.1354" stroke="#F4B125" stroke-linecap="round" />
                                                    <path d="M90.5488 16.0056H91.5649" stroke="#F4B125" stroke-linecap="round" />
                                                    <defs>
                                                        <filter id="filter0_d_4344_13430" x="8.31055" y="21.8936" width="111.372" height="38.2173"
                                                            filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                            <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                                            <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                result="hardAlpha" />
                                                            <feOffset dy="2" />
                                                            <feGaussianBlur stdDeviation="4" />
                                                            <feComposite in2="hardAlpha" operator="out" />
                                                            <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0" />
                                                            <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4344_13430" />
                                                            <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4344_13430" result="shape" />
                                                        </filter>
                                                        <filter id="filter1_d_4344_13430" x="8.31055" y="48.1748" width="111.372" height="38.2173"
                                                            filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                            <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                                            <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                result="hardAlpha" />
                                                            <feOffset dy="2" />
                                                            <feGaussianBlur stdDeviation="4" />
                                                            <feComposite in2="hardAlpha" operator="out" />
                                                            <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0" />
                                                            <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4344_13430" />
                                                            <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4344_13430" result="shape" />
                                                        </filter>
                                                        <filter id="filter2_d_4344_13430" x="8.31055" y="74.4541" width="111.372" height="38.2173"
                                                            filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                            <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                                            <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
                                                                result="hardAlpha" />
                                                            <feOffset dy="2" />
                                                            <feGaussianBlur stdDeviation="4" />
                                                            <feComposite in2="hardAlpha" operator="out" />
                                                            <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0" />
                                                            <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4344_13430" />
                                                            <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4344_13430" result="shape" />
                                                        </filter>
                                                    </defs>
                                                </svg>
                                                <div class="bpa-front-ntb__val"><?php echo esc_html($no_timeslots_available); ?></div>
                                            </div>
                                            <!-- timseslot realted changes end -->
                                            <div class="bpa-front--dt__ts-body">
                                                <div class="bpa-front--dt__ts-body--row" v-if="typeof service_timing.morning_time !== 'undefined' && service_timing.morning_time != ''">
                                                    <div class="bpa-front--dt-ts__sub-heading"><?php echo wp_kses($bookingpress_morning_text, $bookingpress_allow_tag); ?></div>
                                                    <div class="bpa-front--dt__ts-body--items">
                                                        <div class="bpa-front--dt__ts-body--item" :class="( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : '')" v-for="time_details in service_timing.morning_time" @click="(time_details.is_booked || time_details.disable_flag_timeslot ) ? '' : selectTiming(time_details.start_time, time_details.end_time,'','','',time_details.formatted_start_time,time_details.formatted_end_time,time_details)" v-if="!time_details.is_booked">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }} 
                                                            </span>
                                                        </div>

                                                        <div class="bpa-front--dt__ts-body--item" :class="( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : '')" v-for="time_details in service_timing.morning_time" v-if="time_details.is_booked">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }} 
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="bpa-front--dt__ts-body--row" v-if="typeof service_timing.afternoon_time !== 'undefined' && service_timing.afternoon_time != ''">
                                                    <div class="bpa-front--dt-ts__sub-heading"><?php echo wp_kses($bookingpress_afternoon_text, $bookingpress_allow_tag); ?></div>
                                                    <div class="bpa-front--dt__ts-body--items">
                                                        <div class="bpa-front--dt__ts-body--item" :class="( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : '')" v-for="time_details in service_timing.afternoon_time" @click="(time_details.is_booked || time_details.disable_flag_timeslot ) ? '' : selectTiming(time_details.start_time, time_details.end_time,'','','',time_details.formatted_start_time,time_details.formatted_end_time,time_details)" v-if="!time_details.is_booked">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }} 
                                                            </span>
                                                        </div>

                                                        <div class="bpa-front--dt__ts-body--item" :class="( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : '')" v-for="time_details in service_timing.afternoon_time" v-if="time_details.is_booked">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="bpa-front--dt__ts-body--row" v-if="typeof service_timing.evening_time !== 'undefined' && service_timing.evening_time != ''">
                                                    <div class="bpa-front--dt-ts__sub-heading"><?php echo wp_kses($bookingpress_evening_text, $bookingpress_allow_tag); ?></div>
                                                    <div class="bpa-front--dt__ts-body--items">
                                                        <div class="bpa-front--dt__ts-body--item" :class="( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : '')" v-for="time_details in service_timing.evening_time" @click="(time_details.is_booked || time_details.disable_flag_timeslot ) ? '' : selectTiming(time_details.start_time, time_details.end_time,'','','',time_details.formatted_start_time,time_details.formatted_end_time,time_details)" v-if="!time_details.is_booked">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }}
                                                            </span>
                                                        </div>

                                                        <div class="bpa-front--dt__ts-body--item" :class="( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : '')" v-for="time_details in service_timing.evening_time" v-if="time_details.is_booked">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }} 
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="bpa-front--dt__ts-body--row" v-if="typeof service_timing.night_time !== 'undefined' && service_timing.night_time != ''">
                                                    <div class="bpa-front--dt-ts__sub-heading"><?php echo wp_kses($bookingpress_night_text, $bookingpress_allow_tag); ?></div>
                                                    <div class="bpa-front--dt__ts-body--items">
                                                        <div class="bpa-front--dt__ts-body--item" :class="( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : '')" v-for="time_details in service_timing.night_time" @click="(time_details.is_booked || time_details.disable_flag_timeslot ) ? '' : selectTiming(time_details.start_time, time_details.end_time,'','','',time_details.formatted_start_time,time_details.formatted_end_time,time_details)" v-if="!time_details.is_booked">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }}
                                                            </span>
                                                        </div>

                                                        <div class="bpa-front--dt__ts-body--item" :class="( (time_details.is_booked || time_details.disable_flag_timeslot ) ? '__bpa-is-disabled' : (appointment_step_form_data.selected_start_time == time_details.start_time) ? '__bpa-is-selected' : '')" v-for="time_details in service_timing.night_time" v-if="time_details.is_booked">
                                                            <span>
                                                                {{ time_details.formatted_start_end_time }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </el-col>
                                </el-row>
                            </div>
                        </el-col>
                    </el-row>
                    
                </div>
                <div class="bpa-front-dc--footer" :class="bookingpress_footer_dynamic_class">
                    <el-row>
                        <el-col>
                            <div class="bpa-front-tabs--foot">
                                <el-button class="bpa-front-btn bpa-front-btn__medium bpa-front-btn--borderless" @click="bookingpress_step_navigation(bookingpress_sidebar_step_data['datetime'].previous_tab_name, bookingpress_sidebar_step_data['datetime'].next_tab_name, bookingpress_sidebar_step_data['datetime'].previous_tab_name)" v-if="hide_category_service != '1'">                                    
                                    <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24"><rect fill="none" height="24" width="24"/><path d="M9.7,18.3L9.7,18.3c0.39-0.39,0.39-1.02,0-1.41L5.83,13H21c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H5.83l3.88-3.88 c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0L2.7,11.3c-0.39,0.39-0.39,1.02,0,1.41l5.59,5.59 C8.68,18.68,9.32,18.68,9.7,18.3z"/></svg>
                                    <?php echo esc_html($bookingpress_goback_btn_text); ?>
                                </el-button>
                                <el-button class="bpa-front-btn bpa-front-btn__medium bpa-front-btn--primary" @click="bookingpress_step_navigation(bookingpress_sidebar_step_data['datetime'].next_tab_name, bookingpress_sidebar_step_data['datetime'].next_tab_name, bookingpress_sidebar_step_data['datetime'].previous_tab_name)">
									<?php echo esc_html( $bookingpress_next_btn_text ); ?>&nbsp;<strong class="">{{ bookingpress_sidebar_step_data[bookingpress_sidebar_step_data[bookingpress_current_tab].next_tab_name].tab_name }}</strong>                                    
                                    <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24"><rect fill="none" height="24" width="24"/><path d="M14.29,5.71L14.29,5.71c-0.39,0.39-0.39,1.02,0,1.41L18.17,11H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h15.18l-3.88,3.88 c-0.39,0.39-0.39,1.02,0,1.41l0,0c0.39,0.39,1.02,0.39,1.41,0l5.59-5.59c0.39-0.39,0.39-1.02,0-1.41L15.7,5.71 C15.32,5.32,14.68,5.32,14.29,5.71z"/></svg>
                                </el-button>
                            </div>
                        </el-col>
                    </el-row>
                </div>
            </div>
        </div><!--end of tab two--> 

        <div class="bpa-front-tabs--panel-body" :class="[bookingpress_current_tab == 'basic_details' ? ' __bpa-is-active' : '']">
            <div class="bpa-front-default-card">
                <div class="bpa-front-toast-notification --bpa-error" v-if="is_display_error == '1'">
                    <div class="bpa-front-tn-body">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 7c.55 0 1 .45 1 1v4c0 .55-.45 1-1 1s-1-.45-1-1V8c0-.55.45-1 1-1zm-.01-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm1-3h-2v-2h2v2z"/></svg>
                        <p>{{ is_error_msg }}</p>
                    </div>
                </div>
                <div class="bpa-front-dc--body">
                    <el-row>
                        <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                            <div class="bpa-front-module-container bpa-front-module--basic-details">                                
                                <el-row>
                                    <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                                        <div class="bpa-front-module-heading"><?php echo esc_html($bookingpress_third_tab_name); ?></div>
                                    </el-col>
                                </el-row>
                                <el-row>
                                    <el-form :model="appointment_step_form_data" :rules="customer_details_rule" ref="appointment_step_form_data">
                                        <el-col>
                                            <div class="bpa-front-module--bd-form">
                                                <el-row :gutter="24" class="bpa-bd-fields-row">
                                                    <el-col :xs="24" :sm="24" :md="8" :lg="8" :xl="8" v-for="customer_form_fields_data in customer_form_fields" v-if="customer_form_fields_data.is_hide != '1'" :class="customer_form_fields_data.field_name == 'terms_and_conditions' ? 'bpa_terms_conditions':''">
                                                        <el-form-item :prop="customer_form_fields_data.v_model_value" :ref="customer_form_fields_data.v_model_value" v-if="customer_form_fields_data.field_name != 'phone_number' && customer_form_fields_data.is_hide != '1'">
                                                            <template #label v-if="customer_form_fields_data.label != '' && customer_form_fields_data.field_name != 'terms_and_conditions'">
                                                                <span class="bpa-front-form-label">{{ customer_form_fields_data.label }}</span>        
                                                            </template>

                                                            <el-input type="textarea" v-if="customer_form_fields_data.field_name == 'note'" v-model="appointment_step_form_data[customer_form_fields_data['v_model_value']]" class="bpa-front-form-control" :placeholder="customer_form_fields_data.placeholder"></el-input>

                                                            <el-input v-model="appointment_step_form_data[customer_form_fields_data['v_model_value']]" class="bpa-front-form-control" :placeholder="customer_form_fields_data.placeholder" :disabled="check_bookingpress_username_set == 1 && customer_form_fields_data.field_name == 'username' ? true: false" @change="customer_form_fields_data.field_name == 'username' ? bpa_check_username_validation($event) : ''" v-if="customer_form_fields_data.field_name != 'email_address' && customer_form_fields_data.field_name != 'terms_and_conditions' && customer_form_fields_data.field_name != 'note' "></el-input>

                                                            <el-input type="email" v-if="customer_form_fields_data.field_name == 'email_address'" v-model="appointment_step_form_data[customer_form_fields_data['v_model_value']]" class="bpa-front-form-control" :placeholder="customer_form_fields_data.placeholder"></el-input>

                                                            <el-checkbox v-model="appointment_step_form_data[customer_form_fields_data['v_model_value']]" v-if="customer_form_fields_data.field_name == 'terms_and_conditions'" class="bpa-front-form-control--checkbox" :label="true" :name="customer_form_fields_data['v_model_value']"><div v-html="customer_form_fields_data.label"></div></el-checkbox>

                                                        </el-form-item>
                                                        <el-form-item prop="customer_phone" :data-tel-id="customer_form_fields_data.v_model_value" ref="customer_phone" v-if="customer_form_fields_data.field_name == 'phone_number' && customer_form_fields_data.is_hide != '1'">
                                                            <template #label v-if="customer_form_fields_data.label != ''">
                                                                <span class="bpa-front-form-label">{{ customer_form_fields_data.label }}</span>        
                                                            </template>
                                                            <vue-tel-input v-model="appointment_step_form_data.customer_phone" class="bpa-front-form-control --bpa-country-dropdown" @open="bookingpress_phone_country_open( customer_form_fields_data.v_model_value )" @close="bookingpress_phone_country_close( customer_form_fields_data.v_model_value )" @country-changed="bookingpress_phone_country_change_func($event)" v-bind="bookingpress_tel_input_props" ref="bpa_tel_input_field" :mode="vue_tel_mode" :auto-format="vue_tel_auto_format" >
                                                                <template v-slot:arrow-icon>                                                                    
                                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M8.12 9.29L12 13.17l3.88-3.88c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-4.59 4.59c-.39.39-1.02.39-1.41 0L6.7 10.7c-.39-.39-.39-1.02 0-1.41.39-.38 1.03-.39 1.42 0z"/></svg>
                                                                </template>
                                                            </vue-tel-input>
                                                        </el-form-item>
                                                    </el-col>
                                                </el-row>
                                            </div>
                                        </el-col>
                                    </el-form>
                                </el-row>
                            </div>
                        </el-col>
                    </el-row>
                </div>
                <div class="bpa-front-dc--footer" :class="bookingpress_footer_dynamic_class">
                    <el-row>
                        <el-col>
                            <div class="bpa-front-tabs--foot">
                                <el-button class="bpa-front-btn bpa-front-btn__medium bpa-front-btn--borderless" @click="bookingpress_step_navigation(bookingpress_sidebar_step_data['basic_details'].previous_tab_name, bookingpress_sidebar_step_data['basic_details'].next_tab_name, bookingpress_sidebar_step_data['basic_details'].previous_tab_name)">                                    
                                    <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24"><rect fill="none" height="24" width="24"/><path d="M9.7,18.3L9.7,18.3c0.39-0.39,0.39-1.02,0-1.41L5.83,13H21c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H5.83l3.88-3.88 c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0L2.7,11.3c-0.39,0.39-0.39,1.02,0,1.41l5.59,5.59 C8.68,18.68,9.32,18.68,9.7,18.3z"/></svg>
                                    <?php echo esc_html($bookingpress_goback_btn_text); ?>
                                </el-button>
                                <el-button class="bpa-front-btn bpa-front-btn__medium bpa-front-btn--primary" @click="bookingpress_step_navigation(bookingpress_sidebar_step_data['basic_details'].next_tab_name, bookingpress_sidebar_step_data['basic_details'].next_tab_name, bookingpress_sidebar_step_data['basic_details'].previous_tab_name)" ref="validteBtn">
								    <?php echo esc_html( $bookingpress_next_btn_text ); ?>&nbsp;<strong class="">{{ bookingpress_sidebar_step_data[bookingpress_sidebar_step_data[bookingpress_current_tab].next_tab_name].tab_name }}</strong>                                    
                                    <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24"><rect fill="none" height="24" width="24"/><path d="M14.29,5.71L14.29,5.71c-0.39,0.39-0.39,1.02,0,1.41L18.17,11H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h15.18l-3.88,3.88 c-0.39,0.39-0.39,1.02,0,1.41l0,0c0.39,0.39,1.02,0.39,1.41,0l5.59-5.59c0.39-0.39,0.39-1.02,0-1.41L15.7,5.71 C15.32,5.32,14.68,5.32,14.29,5.71z"/></svg>
                                </el-button>
                            </div>
                        </el-col>
                    </el-row>
                </div>
            </div>
        </div><!--end of tab three--> 
        
        <div class="bpa-front-tabs--panel-body" :class="[bookingpress_current_tab == 'summary' ? ' __bpa-is-active' : '']">    
            <div class="bpa-front-default-card">
                <div class="bpa-front-toast-notification --bpa-error" v-if="is_display_error == '1'">
                    <div class="bpa-front-tn-body">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 7c.55 0 1 .45 1 1v4c0 .55-.45 1-1 1s-1-.45-1-1V8c0-.55.45-1 1-1zm-.01-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm1-3h-2v-2h2v2z"/></svg>
                        <p>{{ is_error_msg }}</p>
                    </div>
                </div>
                <div class="bpa-front-dc--body">
                    <el-row>
                        <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">
                            <div class="bpa-front-module-container bpa-front-module--booking-summary bpa-fm__booking-summary-v47">
                                <div class="bpa-front-module--bs-head">
                                    <svg width="137" height="99" viewBox="0 0 137 99" fill="none" xmlns="http://www.w3.org/2000/svg" class="bpa-head__vector">
                                        <path d="M15.8625 62.0651H97.6116C98.7623 62.0661 99.8656 62.5237 100.679 63.3374C101.493 64.1511 101.951 65.2543 101.952 66.4051V79.6535C101.951 80.8042 101.493 81.9075 100.679 82.7212C99.8656 83.5349 98.7623 83.9924 97.6116 83.9935H15.8625C14.7117 83.9924 13.6085 83.5349 12.7948 82.7212C11.9811 81.9075 11.5235 80.8042 11.5225 79.6535V66.4051C11.5235 65.2543 11.9811 64.1511 12.7948 63.3374C13.6085 62.5237 14.7117 62.0661 15.8625 62.0651Z" fill="#E9EDF5"/>
                                        <path d="M15.7854 30.7217H97.5345C98.6852 30.7227 99.7885 31.1803 100.602 31.994C101.416 32.8077 101.873 33.911 101.875 35.0617V48.3101C101.873 49.4608 101.416 50.5641 100.602 51.3778C99.7885 52.1915 98.6852 52.6491 97.5345 52.6501H15.7854C14.6346 52.6491 13.5313 52.1915 12.7177 51.3778C11.904 50.5641 11.4464 49.4608 11.4454 48.3101V35.0617C11.4464 33.911 11.904 32.8077 12.7177 31.994C13.5313 31.1803 14.6346 30.7227 15.7854 30.7217ZM11.9022 48.3101C11.9037 49.3395 12.3133 50.3264 13.0412 51.0543C13.7691 51.7822 14.7559 52.1918 15.7854 52.1933H97.5345C98.5639 52.1918 99.5508 51.7822 100.279 51.0543C101.007 50.3264 101.416 49.3395 101.418 48.3101V35.0617C101.416 34.0322 101.007 33.0454 100.279 32.3175C99.5508 31.5896 98.5639 31.18 97.5345 31.1785H15.7854C14.7559 31.18 13.7691 31.5896 13.0412 32.3175C12.3133 33.0454 11.9037 34.0322 11.9022 35.0617V48.3101Z" fill="#535D71"/>
                                        <path d="M26.9395 47.8533H66.2023C66.687 47.8533 67.1517 47.6608 67.4944 47.3181C67.8371 46.9754 68.0297 46.5106 68.0297 46.026C68.0297 45.5413 67.8371 45.0765 67.4944 44.7338C67.1517 44.3911 66.687 44.1986 66.2023 44.1986H26.9395C26.4548 44.1986 25.99 44.3911 25.6473 44.7338C25.3046 45.0765 25.1121 45.5413 25.1121 46.026C25.1121 46.5106 25.3046 46.9754 25.6473 47.3181C25.99 47.6608 26.4548 47.8533 26.9395 47.8533Z" fill="#E9EDF5"/>
                                        <path d="M53.2079 40.0871H66.2023C66.687 40.0871 67.1517 39.8946 67.4944 39.5519C67.8371 39.2092 68.0297 38.7444 68.0297 38.2597C68.0297 37.7751 67.8371 37.3103 67.4944 36.9676C67.1517 36.6249 66.687 36.4324 66.2023 36.4324H53.2079C52.7232 36.4324 52.2584 36.6249 51.9157 36.9676C51.573 37.3103 51.3805 37.7751 51.3805 38.2597C51.3805 38.7444 51.573 39.2092 51.9157 39.5519C52.2584 39.8946 52.7232 40.0871 53.2079 40.0871Z" fill="#E9EDF5"/>
                                        <path class="bpa-head__vector-item" d="M80.8983 49.24C82.3923 49.24 83.8527 48.797 85.095 47.9669C86.3372 47.1369 87.3054 45.9572 87.8771 44.5769C88.4489 43.1966 88.5985 41.6778 88.307 40.2125C88.0155 38.7472 87.2961 37.4012 86.2397 36.3448C85.1833 35.2884 83.8373 34.5689 82.372 34.2775C80.9067 33.986 79.3879 34.1356 78.0076 34.7073C76.6274 35.2791 75.4476 36.2472 74.6176 37.4895C73.7876 38.7317 73.3445 40.1921 73.3445 41.6861C73.3468 43.6888 74.1434 45.6088 75.5595 47.025C76.9756 48.4411 78.8956 49.2377 80.8983 49.24Z" />
                                        <path d="M79.7164 44.3433C79.529 44.3436 79.3466 44.283 79.1966 44.1705L79.1874 44.1636L77.2295 42.6659C77.1386 42.5964 77.0623 42.5098 77.005 42.4108C76.9476 42.3118 76.9103 42.2025 76.8953 42.0892C76.8802 41.9758 76.8877 41.8606 76.9172 41.7501C76.9467 41.6396 76.9977 41.536 77.0673 41.4452C77.1369 41.3544 77.2237 41.2783 77.3227 41.2211C77.4218 41.1639 77.5311 41.1268 77.6445 41.1119C77.7579 41.097 77.8731 41.1046 77.9836 41.1343C78.094 41.164 78.1976 41.2152 78.2882 41.2849L79.5564 42.2574L82.553 38.3479C82.6225 38.2572 82.7092 38.1812 82.8081 38.124C82.9069 38.0669 83.0161 38.0298 83.1293 38.0148C83.2426 37.9999 83.3576 38.0073 83.468 38.0369C83.5783 38.0664 83.6817 38.1173 83.7724 38.1868L83.7726 38.187L83.754 38.2128L83.7731 38.187C83.956 38.3276 84.0756 38.5349 84.1058 38.7635C84.1359 38.9922 84.0742 39.2234 83.934 39.4066L80.4092 44.003C80.3277 44.1089 80.2229 44.1946 80.1028 44.2534C79.9828 44.3122 79.8509 44.3427 79.7172 44.3423L79.7164 44.3433Z" fill="white"/>
                                        <path d="M50.9109 66.3674H132.66C133.811 66.3685 134.914 66.8261 135.728 67.6397C136.541 68.4534 136.999 69.5567 137 70.7074V83.9558C136.999 85.1066 136.541 86.2099 135.728 87.0235C134.914 87.8372 133.811 88.2948 132.66 88.2958H50.9109C49.7601 88.2948 48.6568 87.8372 47.8432 87.0235C47.0295 86.2099 46.5719 85.1066 46.5709 83.9558V70.7074C46.5719 69.5567 47.0295 68.4534 47.8432 67.6397C48.6568 66.8261 49.7601 66.3685 50.9109 66.3674Z" fill="white"/>
                                        <path d="M50.9109 66.3674H132.66C133.811 66.3685 134.914 66.8261 135.728 67.6397C136.541 68.4534 136.999 69.5567 137 70.7074V83.9558C136.999 85.1066 136.541 86.2099 135.728 87.0235C134.914 87.8372 133.811 88.2948 132.66 88.2958H50.9109C49.7601 88.2948 48.6568 87.8372 47.8432 87.0235C47.0295 86.2099 46.5719 85.1066 46.5709 83.9558V70.7074C46.5719 69.5567 47.0295 68.4534 47.8432 67.6397C48.6568 66.8261 49.7601 66.3685 50.9109 66.3674ZM47.0277 83.9558C47.0292 84.9853 47.4388 85.9721 48.1667 86.7001C48.8946 87.428 49.8814 87.8375 50.9109 87.839H132.66C133.689 87.8375 134.676 87.428 135.404 86.7001C136.132 85.9721 136.542 84.9853 136.543 83.9558V70.7074C136.542 69.678 136.132 68.6911 135.404 67.9632C134.676 67.2353 133.689 66.8257 132.66 66.8243H50.9109C49.8814 66.8257 48.8946 67.2353 48.1667 67.9632C47.4388 68.6911 47.0292 69.678 47.0277 70.7074V83.9558Z" fill="#535D71"/>
                                        <path d="M62.0646 83.4989H101.327C101.812 83.4989 102.277 83.3063 102.62 82.9636C102.962 82.6209 103.155 82.1561 103.155 81.6715C103.155 81.1868 102.962 80.722 102.62 80.3793C102.277 80.0366 101.812 79.8441 101.327 79.8441H62.0646C61.58 79.8441 61.1152 80.0366 60.7725 80.3793C60.4298 80.722 60.2373 81.1868 60.2373 81.6715C60.2373 82.1561 60.4298 82.6209 60.7725 82.9636C61.1152 83.3063 61.58 83.4989 62.0646 83.4989Z" fill="#E9EDF5"/>
                                        <path d="M88.3324 75.7326H101.327C101.567 75.7326 101.804 75.6854 102.026 75.5935C102.248 75.5017 102.449 75.3671 102.619 75.1974C102.789 75.0277 102.923 74.8263 103.015 74.6046C103.107 74.3829 103.154 74.1452 103.154 73.9052C103.154 73.6653 103.107 73.4277 103.015 73.2059C102.923 72.9842 102.789 72.7828 102.619 72.6131C102.449 72.4434 102.248 72.3088 102.026 72.217C101.804 72.1252 101.567 72.0779 101.327 72.0779H88.3324C87.8478 72.0779 87.383 72.2704 87.0403 72.6131C86.6976 72.9558 86.5051 73.4206 86.5051 73.9052C86.5051 74.3899 86.6976 74.8547 87.0403 75.1974C87.383 75.5401 87.8478 75.7326 88.3324 75.7326Z" fill="#E9EDF5"/>
                                        <path class="bpa-head__vector-item" d="M116.024 84.8853C117.518 84.8854 118.978 84.4423 120.22 83.6123C121.463 82.7823 122.431 81.6026 123.002 80.2223C123.574 78.842 123.724 77.3232 123.432 75.8579C123.141 74.3926 122.421 73.0466 121.365 71.9902C120.309 70.9338 118.963 70.2143 117.497 69.9229C116.032 69.6314 114.513 69.781 113.133 70.3527C111.753 70.9244 110.573 71.8926 109.743 73.1348C108.913 74.3771 108.47 75.8375 108.47 77.3315C108.472 79.3342 109.269 81.2542 110.685 82.6704C112.101 84.0865 114.021 84.8831 116.024 84.8853Z" />
                                        <path d="M114.842 79.9884C114.654 79.9887 114.472 79.9281 114.322 79.8157L114.313 79.8087L112.355 78.311C112.264 78.2416 112.188 78.1549 112.13 78.0559C112.073 77.957 112.036 77.8477 112.021 77.7343C112.006 77.6209 112.013 77.5057 112.043 77.3952C112.072 77.2847 112.123 77.1811 112.193 77.0903C112.262 76.9996 112.349 76.9234 112.448 76.8662C112.547 76.809 112.656 76.7719 112.77 76.757C112.883 76.7421 112.998 76.7498 113.109 76.7795C113.219 76.8091 113.323 76.8603 113.414 76.93L114.682 77.9025L117.678 73.993C117.748 73.9024 117.835 73.8263 117.933 73.7692C118.032 73.712 118.141 73.6749 118.255 73.66C118.368 73.645 118.483 73.6525 118.593 73.682C118.704 73.7115 118.807 73.7625 118.898 73.832L118.879 73.858L118.898 73.8322C119.081 73.9727 119.201 74.18 119.231 74.4087C119.261 74.6373 119.2 74.8686 119.059 75.0517L115.535 79.6481C115.453 79.754 115.348 79.8397 115.228 79.8985C115.108 79.9574 114.976 79.9878 114.843 79.9874L114.842 79.9884Z" fill="white"/>
                                        <path d="M32.7836 98.9999H0.260187C0.191181 98.9999 0.124997 98.9725 0.0762029 98.9237C0.0274083 98.8749 0 98.8087 0 98.7397C0 98.6707 0.0274083 98.6045 0.0762029 98.5557C0.124997 98.5069 0.191181 98.4795 0.260187 98.4795H32.7836C32.8526 98.4795 32.9188 98.5069 32.9676 98.5557C33.0164 98.6045 33.0438 98.6707 33.0438 98.7397C33.0438 98.8087 33.0164 98.8749 32.9676 98.9237C32.9188 98.9725 32.8526 98.9999 32.7836 98.9999Z" fill="#202C45"/>
                                        <path d="M28.0083 17.5336C27.7067 17.724 27.4505 17.9782 27.2577 18.2783C27.065 18.5784 26.9404 18.9171 26.8927 19.2706C26.845 19.624 26.8754 19.9837 26.9818 20.3241C27.0881 20.6646 27.2678 20.9776 27.5082 21.2411L25.1438 26.2902L27.8616 28.4754L31.1005 21.2982C31.5164 20.865 31.759 20.2943 31.7822 19.6943C31.8054 19.0942 31.6077 18.5064 31.2266 18.0424C30.8454 17.5784 30.3073 17.2702 29.7141 17.1765C29.121 17.0827 28.514 17.2097 28.0083 17.5336V17.5336Z" fill="#FFB8B8"/>
                                        <path d="M14.4212 19.5826C15.1694 19.1331 16.062 18.9889 16.9138 19.1798C17.7656 19.3708 18.5112 19.8822 18.996 20.6081L23.8341 27.8524L25.5138 24.1495C25.6186 23.9183 25.8044 23.7334 26.0361 23.6296C26.2679 23.5258 26.5295 23.5103 26.7719 23.586L29.307 24.3779C29.4394 24.4193 29.5622 24.4867 29.6682 24.5763C29.7742 24.6658 29.8613 24.7756 29.9242 24.8993C29.9871 25.023 30.0247 25.158 30.0347 25.2964C30.0447 25.4348 30.0269 25.5737 29.9824 25.7052L28.2471 30.8294C28.0275 31.4776 27.6608 32.0661 27.1755 32.5487C26.6903 33.0313 26.0998 33.3948 25.4505 33.6108C24.8011 33.8268 24.1105 33.8894 23.4329 33.7935C22.7552 33.6977 22.1091 33.4461 21.545 33.0586C21.2815 32.8774 21.0383 32.6683 20.8198 32.4348L13.69 24.8167C13.3438 24.4468 13.0847 24.0041 12.9317 23.521C12.7787 23.038 12.7356 22.5269 12.8057 22.0251C12.8758 21.5233 13.0573 21.0435 13.3368 20.6209C13.6163 20.1982 13.9868 19.8435 14.4212 19.5826Z" fill="#CFD6E6"/>
                                        <path d="M30.0722 12.0974C30.202 12.1007 30.3253 12.1553 30.4148 12.2495C30.5044 12.3436 30.5529 12.4694 30.5496 12.5992L30.5079 14.2807L30.5922 14.2884L30.5619 15.4305L30.4796 15.4202L30.3299 21.4442C30.3248 21.6503 30.2449 21.8476 30.105 21.9992C29.9651 22.1507 29.7749 22.2462 29.5697 22.2678L25.7393 22.6711C25.6461 22.6809 25.5518 22.6702 25.4631 22.6397C25.3744 22.6092 25.2935 22.5597 25.2259 22.4947C25.1584 22.4296 25.1059 22.3506 25.0721 22.2631C25.0384 22.1756 25.0242 22.0818 25.0305 21.9882L25.6115 13.4105C25.6237 13.2303 25.6968 13.0597 25.8189 12.9266C25.9409 12.7935 26.1046 12.7059 26.283 12.6782L29.9808 12.1037C30.011 12.0988 30.0416 12.0967 30.0722 12.0974Z" fill="#202C45"/>
                                        <path d="M27.1076 12.9902L29.0515 12.6882C29.0865 12.6827 29.1187 12.6659 29.1432 12.6403C29.1677 12.6147 29.183 12.5818 29.1869 12.5466C29.1912 12.5067 29.2086 12.4694 29.2363 12.4404C29.264 12.4114 29.3005 12.3923 29.3401 12.3862L29.7496 12.3226C29.8055 12.3139 29.8626 12.3176 29.9169 12.3334C29.9712 12.3492 30.0214 12.3767 30.0638 12.414C30.1063 12.4513 30.1401 12.4975 30.1628 12.5493C30.1856 12.601 30.1966 12.6572 30.1953 12.7137L29.9848 21.4474C29.9822 21.5558 29.9397 21.6594 29.8656 21.7385C29.7915 21.8176 29.6908 21.8667 29.5828 21.8762L25.7552 22.2166C25.7064 22.2209 25.6572 22.2146 25.611 22.1982C25.5648 22.1818 25.5227 22.1556 25.4875 22.1215C25.4524 22.0873 25.425 22.0459 25.4073 22.0002C25.3896 21.9545 25.382 21.9055 25.385 21.8566L25.9014 13.3581C25.9091 13.2329 25.9593 13.1141 26.0437 13.0213C26.1282 12.9286 26.2418 12.8675 26.3658 12.8483L26.7975 12.7812C26.8133 12.8487 26.8541 12.9077 26.9116 12.9464C26.9691 12.9852 27.0391 13.0008 27.1076 12.9902Z" fill="white"/>
                                        <path d="M18.0885 95.8415L21.063 95.8413L22.4776 84.368L18.0875 84.3686L18.0885 95.8415Z" fill="#FFB8B8"/>
                                        <path d="M26.8003 98.603L17.4519 98.6039L17.4515 94.992L23.1881 94.9914C23.6624 94.9914 24.1321 95.0848 24.5703 95.2663C25.0086 95.4477 25.4068 95.7137 25.7422 96.0491C26.0776 96.3845 26.3437 96.7826 26.5253 97.2208C26.7068 97.659 26.8003 98.1287 26.8003 98.603L26.8003 98.603Z" fill="#202C45"/>
                                        <path d="M8.94684 95.8415L11.9213 95.8413L13.3359 84.368L8.9458 84.3686L8.94684 95.8415Z" fill="#FFB8B8"/>
                                        <path d="M17.6581 98.603L8.30959 98.6039L8.30927 94.992L14.0458 94.9914C15.0038 94.9914 15.9225 95.3718 16.5999 96.0491C17.2773 96.7264 17.658 97.6451 17.6581 98.603L17.6581 98.603Z" fill="#202C45"/>
                                        <path d="M17.6582 15.6833C21.1875 15.6833 24.0486 12.8222 24.0486 9.29281C24.0486 5.76345 21.1875 2.90234 17.6582 2.90234C14.1288 2.90234 11.2677 5.76345 11.2677 9.29281C11.2677 12.8222 14.1288 15.6833 17.6582 15.6833Z" fill="#FFB8B8"/>
                                        <path d="M20.9469 26.3904C20.8947 24.7474 20.4322 23.1436 19.6014 21.7251C18.7707 20.3067 17.5982 19.1187 16.1908 18.2694C14.5398 17.2965 12.7327 16.9171 11.295 18.3548C10.4317 19.2397 9.74034 20.2774 9.25615 21.4149C7.92622 24.5147 7.83921 28.0072 9.01314 31.1694L12.435 40.623L20.3549 41.481C20.5036 41.4971 20.6541 41.481 20.7961 41.4337C20.938 41.3863 21.0681 41.309 21.1775 41.2068C21.2868 41.1047 21.3728 40.9802 21.4297 40.8417C21.4865 40.7033 21.5129 40.5543 21.5069 40.4048L20.9469 26.3904Z" fill="#535D71"/>
                                        <path d="M12.9372 39.4589C12.9372 39.4589 7.02024 41.6678 8.56723 51.0212C9.95541 59.4144 8.85224 87.273 8.61112 92.9044C8.59964 93.1728 8.6925 93.4352 8.87023 93.6367C9.04796 93.8382 9.29678 93.963 9.56452 93.9851L13.0185 94.2729C13.289 94.2955 13.5577 94.2114 13.7671 94.0387C13.9765 93.866 14.1102 93.6183 14.1396 93.3484L15.9234 76.9635C15.9304 76.8992 15.9611 76.8398 16.0095 76.7969C16.0579 76.754 16.1206 76.7307 16.1852 76.7314C16.2499 76.7322 16.312 76.7571 16.3593 76.8011C16.4067 76.8452 16.4359 76.9053 16.4413 76.9698L17.7706 92.7359C17.7929 93.0015 17.9164 93.2484 18.1155 93.4257C18.3146 93.603 18.5741 93.6971 18.8405 93.6887L21.7417 93.5969C21.8784 93.5926 22.0129 93.5613 22.1375 93.505C22.2622 93.4486 22.3745 93.3683 22.468 93.2685C22.5616 93.1687 22.6345 93.0514 22.6827 92.9234C22.7309 92.7954 22.7534 92.6592 22.7489 92.5225L21.04 40.5514L12.9372 39.4589Z" fill="#535D71"/>
                                        <path d="M18.9407 8.8717C21.0779 9.74826 23.8073 8.72431 24.8406 6.65829C25.874 4.59227 25.0562 1.79419 23.0729 0.609824C21.0896 -0.574543 18.2383 0.0325306 16.9095 1.9221C15.8286 -0.0252986 12.9969 -0.521775 11.0526 0.564842C9.10839 1.65146 8.04938 3.92749 7.92378 6.15122C7.79818 8.37495 8.47424 10.5656 9.29896 12.6346C10.633 15.9813 14.9276 17.7833 18.2502 16.3905C16.7291 14.125 17.0294 10.8096 18.9407 8.8717Z" fill="#202C45"/>
                                        <path class="bpa-head__vector-item" d="M27.5531 18.3085C27.4963 18.3086 27.4409 18.2902 27.3954 18.256L27.3926 18.2539L26.7984 17.7994C26.7709 17.7783 26.7478 17.752 26.7304 17.722C26.7131 17.6919 26.7018 17.6588 26.6973 17.6244C26.6927 17.5901 26.695 17.5551 26.704 17.5216C26.7129 17.4881 26.7284 17.4567 26.7495 17.4292C26.7706 17.4017 26.7969 17.3786 26.8269 17.3612C26.857 17.3439 26.8901 17.3326 26.9245 17.3281C26.9589 17.3235 26.9938 17.3258 27.0273 17.3348C27.0608 17.3437 27.0922 17.3592 27.1197 17.3803L27.5045 17.6754L28.414 16.489C28.4351 16.4615 28.4614 16.4384 28.4914 16.421C28.5214 16.4037 28.5545 16.3924 28.5889 16.3879C28.6232 16.3834 28.6582 16.3856 28.6916 16.3946C28.7251 16.4035 28.7565 16.419 28.784 16.4401L28.7841 16.4402L28.7784 16.448L28.7842 16.4402C28.8397 16.4828 28.876 16.5457 28.8852 16.6151C28.8943 16.6845 28.8756 16.7547 28.8331 16.8103L27.7634 18.2052C27.7386 18.2373 27.7068 18.2633 27.6704 18.2812C27.634 18.299 27.5939 18.3082 27.5534 18.3081L27.5531 18.3085Z" />
                                        <path d="M25.5268 30.6751C25.1983 30.5362 24.8433 30.471 24.4869 30.4841C24.1305 30.4972 23.7812 30.5882 23.4638 30.7509C23.1464 30.9136 22.8685 31.1438 22.6497 31.4255C22.4309 31.7072 22.2765 32.0334 22.1974 32.3812L16.7021 33.3226L16.4597 36.8016L24.2014 35.3632C24.7945 35.4573 25.4015 35.3306 25.9074 35.0071C26.4133 34.6836 26.783 34.1857 26.9464 33.6079C27.1098 33.03 27.0555 32.4123 26.7938 31.8718C26.5322 31.3312 26.0814 30.9055 25.5268 30.6751L25.5268 30.6751Z" fill="#FFB8B8"/>
                                        <path d="M16.0873 20.6895C16.8836 21.0473 17.5116 21.6978 17.8411 22.5061C18.1706 23.3144 18.1764 24.2186 17.8572 25.031L14.6718 33.139L18.6708 32.404C18.9205 32.3581 19.1784 32.4051 19.3959 32.5361C19.6134 32.667 19.7755 32.873 19.8517 33.1152L20.6489 35.6486C20.6905 35.781 20.7053 35.9203 20.6923 36.0585C20.6793 36.1966 20.6388 36.3308 20.5732 36.453C20.5076 36.5753 20.4182 36.6832 20.3103 36.7705C20.2024 36.8577 20.0781 36.9224 19.9448 36.9609L14.7471 38.4617C14.0896 38.6515 13.397 38.6864 12.7238 38.5635C12.0505 38.4407 11.4149 38.1635 10.8668 37.7536C10.3188 37.3438 9.87314 36.8125 9.56495 36.2015C9.25676 35.5905 9.09439 34.9163 9.09058 34.232C9.0888 33.9122 9.12167 33.5931 9.18861 33.2804L11.3726 23.0775C11.4787 22.582 11.6942 22.1166 12.0034 21.7152C12.3127 21.3138 12.7077 20.9867 13.1597 20.7577C13.6118 20.5288 14.1093 20.4038 14.6158 20.392C15.1224 20.3802 15.6251 20.4819 16.0873 20.6895Z" fill="#CFD6E6"/>
                                    </svg>                                    
                                    <div class="bpa-front-module-heading"><?php echo esc_html($bookingpress_fourth_tab_name); ?></div>
                                    <p><?php echo esc_html($bookingpress_summary_content_text); ?></p>
                                    <div class="bpa-front-module--note-desc" v-if="summary_step_note != ''"><?php echo wp_kses($bookingpress_summary_content_note, $bookingpress_allow_tag); ?></div>
                                </div>
                                <div class="bpa-front-module--bs-summary-content bpa-front-module--bs-customer-detail">
                                    <div class="bpa-front-module--bs-summary-content-item">
                                        <span><?php echo esc_html($bookingpress_customer_text); ?></span>
                                        <div class="bpa-front-bs-sm__item-val" v-if="appointment_step_form_data.customer_name != undefined && appointment_step_form_data.customer_name != ''">
                                        {{appointment_step_form_data.customer_name }}</div> 
                                        <div class="bpa-front-bs-sm__item-val" v-else-if="((appointment_step_form_data.customer_firstname != undefined && appointment_step_form_data.customer_firstname != '') || (appointment_step_form_data.customer_lastname != undefined && appointment_step_form_data.customer_lastname != ''))">{{ appointment_step_form_data.customer_firstname }} {{ appointment_step_form_data.customer_lastname }}</div>
                                        <div class="bpa-front-bs-sm__item-val" v-else>{{ appointment_step_form_data.customer_email }}</div>
                                    </div>
                                </div>
                                <div class="bpa-front-module--bs-summary-content bpa-front-summary-content__lg">
                                    <div class="bpa-front-module--bs-summary-content-item">
                                        <span><?php echo esc_html($bookingpress_service_text); ?></span>
                                        <div class="bpa-front-bs-sm__item-val">{{ appointment_step_form_data.selected_service_name}}</div>
                                    </div>
                                    <div class="bpa-front-module--bs-summary-content-item">
                                        <span><?php echo esc_html($bookingpress_date_time_text); ?></span>
                                        <div class="bpa-front-bs-sm__item-val">{{ appointment_step_form_data.selected_date | bookingpress_format_date }}, {{ appointment_step_form_data.selected_start_time | bookingpress_format_time }} - {{ appointment_step_form_data.selected_end_time | bookingpress_format_time }}</div>
                                    </div>                                    
                                </div>
                                <div class="bpa-front-module--bs-summary-content bpa-front-summary-content__sm">
                                    <div class="bpa-front-module--bs-summary-content-item">
                                        <span><?php echo esc_html($bookingpress_appointment_details_title_text); ?></span>
                                        <div class="bpa-front-bs-sm__item-vals">
                                            <div class="bpa-front-bs-sm__item-val">{{ appointment_step_form_data.selected_service_name}}</div>
                                            <div class="bpa-front-bs-sm__item-val">{{ appointment_step_form_data.selected_date | bookingpress_format_date }}, {{ appointment_step_form_data.selected_start_time | bookingpress_format_time }} - {{ appointment_step_form_data.selected_end_time | bookingpress_format_time }}</div>
                                        </div>
                                    </div>
                                </div>                                    
                                <div class="bpa-front-module--bs-amount-details" v-if="appointment_step_form_data.service_price_without_currency != '0'">
                                    <div class="bpa-fm--bs-amount-item">
                                        <div class="bpa-front-total-payment-amount-label" v-html="bookingpress_total_amount_text" ></div>
                                        <div class="bpa-front-module--bs-ad--price">{{ appointment_step_form_data.selected_service_price }}</div>
                                    </div>
                                </div>
                            </div>
                        </el-col>
                    </el-row>
                    <el-row v-if="appointment_step_form_data.service_price_without_currency != '0' && is_only_onsite_enabled != '1'">
                        <el-col :xs="24" :sm="24" :md="24" :lg="24" :xl="24">                            
                            <div class="bpa-front-module-container bpa-front-module--payment-methods">
                                <div class="bpa-front-module--pm__empty-view" v-if="on_site_payment == 'false' && paypal_payment == 'false'">
                                    <svg width="119" height="120" viewBox="0 0 119 120" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M107.805 102.553C100.361 111.612 86.048 109.191 74.6759 112.045C63.6289 114.817 52.7571 122.664 41.9468 119.079C31.1526 115.498 27.1467 102.715 19.9639 93.8978C12.9065 85.2346 1.36453 78.8344 0.116345 67.7303C-1.13054 56.6378 7.92964 47.426 13.6636 37.8489C18.86 29.1696 23.9531 20.5659 32.0137 14.4536C40.6473 7.9068 50.3951 1.82959 61.2302 1.77951C72.1469 1.72905 81.4043 8.66324 90.8236 14.1818C100.802 20.028 113.76 24.0567 117.769 34.9045C121.774 45.7399 112.447 56.6992 110.764 68.1277C109.05 79.7577 115.268 93.4705 107.805 102.553Z" fill="#F4F7FB"/>
                                        <g filter="url(#filter0_d_2048_8270)">
                                            <rect x="15.6289" y="27.3662" width="95.3718" height="22.2173" rx="11.1086" fill="white"/>
                                        </g>
                                        <circle cx="26.4657" cy="38.4735" r="5.41885" class="bpa-ev__vector-primary-color" />
                                            <rect x="37.3047" y="39.0146" width="41.1833" height="2.16754" rx="1.08377" fill="#F4F7FB"/>
                                            <rect x="37.3047" y="35.4941" width="13.5471" height="2.16754" rx="1.08377" fill="#F4F7FB"/>
                                            <rect x="52.748" y="35.4941" width="25.7395" height="2.16754" rx="1.08377" fill="#F4F7FB"/>
                                            <rect x="83.9043" y="34.4102" width="21.6754" height="8.12828" rx="4" fill="#F4F7FB"/>
                                                <g filter="url(#filter1_d_2048_8270)">
                                            <rect x="15.6289" y="53.6475" width="95.3718" height="22.2173" rx="11.1086" fill="white"/>
                                            </g>
                                        <circle cx="26.4657" cy="64.7558" r="5.41885" fill="#E8ECF5"/>
                                            <rect x="37.3047" y="65.2979" width="41.1833" height="2.16754" rx="1.08377" fill="#E8ECF5"/>
                                            <rect x="37.3047" y="61.7764" width="13.5471" height="2.16754" rx="1.08377" fill="#DDE1ED"/>
                                            <rect x="52.748" y="61.7764" width="25.7395" height="2.16754" rx="1.08377" fill="#E8ECF5"/>
                                            <rect x="83.9043" y="60.6924" width="21.6754" height="8.12828" rx="4" fill="#F4F7FB"/>
                                            <g filter="url(#filter2_d_2048_8270)">
                                                <rect x="15.6289" y="79.9268" width="95.3718" height="22.2173" rx="11.1086" fill="white"/>
                                            </g>
                                        <circle cx="26.4657" cy="91.037" r="5.41885" fill="#E8ECF5"/>
                                        <rect x="37.3047" y="91.5791" width="41.1833" height="2.16754" rx="1.08377" fill="#E8ECF5"/>
                                        <rect x="37.3047" y="88.0547" width="13.5471" height="2.16754" rx="1.08377" fill="#DDE1ED"/>
                                        <rect x="52.748" y="88.0547" width="25.7395" height="2.16754" rx="1.08377" fill="#E8ECF5"/>
                                        <rect x="83.9043" y="86.9717" width="21.6754" height="8.12828" rx="4" class="bpa-ev__vector-primary-color" />
                                        <path d="M11.0359 61.0713H11.5359C11.5359 60.8085 11.3325 60.5906 11.0704 60.5725C10.8082 60.5544 10.5768 60.7423 10.5407 61.0025L11.0359 61.0713ZM9.98828 62.112V61.612C9.72208 61.612 9.50256 61.8206 9.48894 62.0864C9.47531 62.3523 9.67237 62.5822 9.93717 62.6094L9.98828 62.112ZM11.0359 63.2388H10.5359C10.5359 63.5118 10.7549 63.7343 11.0278 63.7388C11.3008 63.7432 11.5268 63.5279 11.5357 63.2551L11.0359 63.2388ZM12.1558 62.1264V62.6264C12.4196 62.6264 12.638 62.4214 12.6548 62.1582C12.6716 61.895 12.481 61.6639 12.2194 61.6304L12.1558 62.1264ZM10.5407 61.0025C10.5259 61.1092 10.4705 61.2835 10.3676 61.4183C10.2764 61.5376 10.1632 61.612 9.98828 61.612V62.612C10.5359 62.612 10.9224 62.3394 11.1624 62.0252C11.3906 61.7263 11.4978 61.3802 11.5312 61.1401L10.5407 61.0025ZM9.93717 62.6094C10.0302 62.6189 10.1965 62.6692 10.3284 62.776C10.4426 62.8685 10.5359 63.0039 10.5359 63.2388H11.5359C11.5359 62.6699 11.28 62.2599 10.9577 61.9988C10.6531 61.7522 10.2955 61.6409 10.0394 61.6146L9.93717 62.6094ZM11.5357 63.2551C11.5392 63.1474 11.5803 62.973 11.6784 62.8394C11.7592 62.7292 11.8898 62.6264 12.1558 62.6264V61.6264C11.5549 61.6264 11.1315 61.8944 10.8722 62.2477C10.6301 62.5776 10.5447 62.9594 10.5362 63.2226L11.5357 63.2551ZM12.2194 61.6304C12.0987 61.6149 11.9016 61.5548 11.7481 61.4443C11.6075 61.343 11.5359 61.2279 11.5359 61.0713H10.5359C10.5359 61.6324 10.8376 62.0209 11.1636 62.2557C11.4768 62.4813 11.8396 62.5899 12.0923 62.6223L12.2194 61.6304Z" fill="#F4B125" fill-opacity="0.6"/>
                                        <line x1="10.7891" y1="59.9189" x2="10.7891" y2="59.8352" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round"/>
                                        <line x1="10.7891" y1="65.3379" x2="10.7891" y2="64.6039" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round"/>
                                        <path d="M12.8047 62.1816H14.1052" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round"/>
                                        <path d="M8.03906 62.1816H8.85189" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round"/>
                                        <path d="M9.66667 39.5487L9.66838 39.554H9.67392L9.66944 39.5572L9.67115 39.5625L9.66667 39.5592L9.66219 39.5625L9.6639 39.5572L9.65942 39.554H9.66496L9.66667 39.5487Z" class="bpa-ev__vector-primary-color--is-storke" />
                                        <path d="M117.233 47.9491L117.235 47.9544H117.24L117.236 47.9576L117.238 47.9629L117.233 47.9596L117.229 47.9629L117.23 47.9576L117.226 47.9544H117.231L117.233 47.9491Z" class="bpa-ev__vector-primary-color--is-storke" />
                                        <path d="M83.905 111.079L83.9067 111.084H83.9122L83.9077 111.087L83.9094 111.093L83.905 111.09L83.9005 111.093L83.9022 111.087L83.8977 111.084H83.9032L83.905 111.079Z" stroke="#F5AE41"/>
                                        <circle cx="55.4563" cy="1.35471" r="0.854713" stroke="#EE2445" stroke-opacity="0.7"/>
                                        <circle cx="110.999" cy="78.5725" r="0.854713" stroke="#EE2445" stroke-opacity="0.6"/>
                                        <circle cx="2.08128" cy="78.5725" r="0.854713" stroke="#EE2445" stroke-opacity="0.6"/>
                                        <circle cx="69.2763" cy="15.4452" r="0.541885" fill="#2166F1"/>
                                        <line x1="43.2246" y1="15.9844" x2="43.2246" y2="19.5066" stroke="#01CB62" stroke-opacity="0.3"/>
                                        <line x1="44.6211" y1="18.1094" x2="41.0988" y2="18.1094" stroke="#01CB62" stroke-opacity="0.3"/>
                                        <line x1="20.6445" y1="105.251" x2="61.2663" y2="105.251" stroke="#DCE4F5" stroke-width="3" stroke-linecap="round"/>
                                        <line x1="68.3359" y1="105.251" x2="87.2823" y2="105.251" stroke="#DCE4F5" stroke-width="3" stroke-linecap="round"/>
                                        <line x1="95.1562" y1="105.251" x2="114.103" y2="105.251" stroke="#DCE4F5" stroke-width="3" stroke-linecap="round"/>
                                        <path d="M93.6181 14.0889H94.1181C94.1181 13.8261 93.9148 13.6082 93.6526 13.5901C93.3905 13.5719 93.159 13.7598 93.1229 14.0201L93.6181 14.0889ZM92.3086 15.3898V14.8898C92.0424 14.8898 91.8229 15.0983 91.8092 15.3642C91.7956 15.63 91.9927 15.8599 92.2575 15.8871L92.3086 15.3898ZM93.6181 16.7983H93.1181C93.1181 17.0713 93.3371 17.2938 93.61 17.2982C93.883 17.3027 94.109 17.0874 94.1179 16.8145L93.6181 16.7983ZM95.018 15.4077V15.9077C95.2818 15.9077 95.5002 15.7028 95.517 15.4395C95.5338 15.1763 95.3432 14.9453 95.0816 14.9118L95.018 15.4077ZM93.1229 14.0201C93.1021 14.1702 93.0264 14.4095 92.8821 14.5985C92.7495 14.772 92.5738 14.8898 92.3086 14.8898V15.8898C92.9465 15.8898 93.3955 15.5738 93.6768 15.2054C93.9465 14.8523 94.074 14.4412 94.1134 14.1576L93.1229 14.0201ZM92.2575 15.8871C92.3942 15.9012 92.6259 15.9716 92.8124 16.1226C92.9812 16.2593 93.1181 16.4629 93.1181 16.7983H94.1181C94.1181 16.1289 93.8186 15.6507 93.4417 15.3455C93.0826 15.0546 92.6595 14.9232 92.3597 14.8924L92.2575 15.8871ZM94.1179 16.8145C94.1229 16.6605 94.1798 16.4166 94.3204 16.225C94.4438 16.0569 94.6436 15.9077 95.018 15.9077V14.9077C94.3087 14.9077 93.8161 15.2221 93.5142 15.6333C93.2296 16.0212 93.1285 16.4725 93.1184 16.7821L94.1179 16.8145ZM95.0816 14.9118C94.9143 14.8903 94.6471 14.8091 94.4353 14.6566C94.2364 14.5133 94.1181 14.3352 94.1181 14.0889H93.1181C93.1181 14.7397 93.4665 15.1911 93.8509 15.468C94.2224 15.7356 94.6551 15.8653 94.9545 15.9036L95.0816 14.9118Z" fill="#F4B125"/>
                                        <line x1="93.4297" y1="12.7754" x2="93.4297" y2="12.4207" stroke="#F4B125" stroke-linecap="round"/>
                                        <line x1="93.4297" y1="19.5498" x2="93.4297" y2="18.3823" stroke="#F4B125" stroke-linecap="round"/>
                                        <path d="M95.8281 15.4785H97.4538" stroke="#F4B125" stroke-linecap="round"/>
                                        <path d="M89.8672 15.4785H90.8832" stroke="#F4B125" stroke-linecap="round"/>
                                        <defs>
                                            <filter id="filter0_d_2048_8270" x="7.62891" y="21.3662" width="111.372" height="38.2173" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                                <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                                <feOffset dy="2"/>
                                                <feGaussianBlur stdDeviation="4"/>
                                                <feComposite in2="hardAlpha" operator="out"/>
                                                <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0"/>
                                                <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2048_8270"/>
                                                <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2048_8270" result="shape"/>
                                            </filter>
                                            <filter id="filter1_d_2048_8270" x="7.62891" y="47.6475" width="111.372" height="38.2173" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                                <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                                <feOffset dy="2"/>
                                                <feGaussianBlur stdDeviation="4"/>
                                                <feComposite in2="hardAlpha" operator="out"/>
                                                <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0"/>
                                                <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2048_8270"/>
                                                <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2048_8270" result="shape"/>
                                            </filter>
                                            <filter id="filter2_d_2048_8270" x="7.62891" y="73.9268" width="111.372" height="38.2173" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                                <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                                                <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                                                <feOffset dy="2"/>
                                                <feGaussianBlur stdDeviation="4"/>
                                                <feComposite in2="hardAlpha" operator="out"/>
                                                <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0"/>
                                                <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_2048_8270"/>
                                                <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2048_8270" result="shape"/>
                                            </filter>
                                        </defs>
                                    </svg>
                                    <div class="bpa-front-pm-ev__title"><?php echo stripslashes_deep(esc_html($no_payment_method_available)); //phpcs:ignore ?></div>
                                </div>
                                <div v-else>
                                    <div class="bpa-front-module--pm-head">                                        
                                        <div class="bpa-front-module-heading"><?php echo esc_html($bookingpress_payment_method_text); ?></div>
                                    </div>
                                    <div class="bpa-front-module--pm-body">
                                        <div class="bpa-front--pm-body-items">
                                            <div class="bpa-front-module--pm-body__item" :class="(appointment_step_form_data.selected_payment_method == 'on-site') ? '__bpa-is-selected' : ''" @click="select_payment_method('on-site')" v-if="on_site_payment != 'false' && on_site_payment != ''">                                                                                            
                                                <svg class="bpa-front-pm-pay-local-icon" xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24"><g><g><rect fill="none" height="24" width="24"/><rect fill="none" height="24" width="24"/></g></g><g><path d="M21.9,7.89l-1.05-3.37c-0.22-0.9-1-1.52-1.91-1.52H5.05c-0.9,0-1.69,0.63-1.9,1.52L2.1,7.89C1.64,9.86,2.95,11,3,11.06V19 c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2v-7.94C22.12,9.94,22.09,8.65,21.9,7.89z M13,5h1.96l0.54,3.52C15.59,9.23,15.11,10,14.22,10 C13.55,10,13,9.41,13,8.69V5z M6.44,8.86C6.36,9.51,5.84,10,5.23,10C4.3,10,3.88,9.03,4.04,8.36L5.05,5h1.97L6.44,8.86z M11,8.69 C11,9.41,10.45,10,9.71,10c-0.75,0-1.3-0.7-1.22-1.48L9.04,5H11V8.69z M18.77,10c-0.61,0-1.14-0.49-1.21-1.14L16.98,5l1.93-0.01 l1.05,3.37C20.12,9.03,19.71,10,18.77,10z"/></g></svg>
                                                <p><?php echo wp_kses($bookingpress_locally_text, $bookingpress_allow_tag); ?></p>
                                                <div class="bpa-front-si-card--checkmark-icon" v-if="appointment_step_form_data.selected_payment_method == 'on-site'">                                                    
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM9.29 16.29 5.7 12.7c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L10 14.17l6.88-6.88c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-7.59 7.59c-.38.39-1.02.39-1.41 0z"/></svg>
                                                </div>
                                            </div>
                                            <div class="bpa-front-module--pm-body__item" :class="(appointment_step_form_data.selected_payment_method == 'paypal') ? '__bpa-is-selected' : ''" @click="select_payment_method('paypal')" v-if="paypal_payment != 'false' && paypal_payment != ''">                                            
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M17.9588 8.24063L8.75722 18.2812H5.38222C5.14786 18.2812 4.96036 18.0469 5.00723 17.8125L7.25722 3.5625C7.30412 3.23438 7.58537 3 7.91347 3H13.6322C17.5697 3.14062 18.6479 5.15622 17.9447 8.25002L17.9588 8.24063Z" fill="#002C8A"/>
                                                    <path d="M18.1088 7.3125C19.5151 8.0625 19.8432 9.4687 19.3744 11.3437C18.7651 14.1094 16.9369 15.2812 14.2651 15.3281L13.5151 15.375C13.2338 15.375 13.0463 15.5625 12.9994 15.8437L12.3901 19.5469C12.3432 19.875 12.0619 20.1094 11.7338 20.1094H8.9213C8.6869 20.1094 8.4994 19.875 8.5463 19.6406L9.57755 12.9375C9.6244 12.7031 18.1088 7.3125 18.1088 7.3125Z" fill="#009BE1"/>
                                                    <path d="M9.52148 13.2656L10.459 7.31252C10.4897 7.17152 10.5661 7.04458 10.6762 6.95138C10.7864 6.85818 10.9242 6.80388 11.0683 6.79688H15.5683C16.6465 6.79688 17.4433 6.98437 18.0996 7.31252C17.8652 9.37502 16.8808 12.7031 12.0996 12.7969H10.0371C9.80268 12.7969 9.56833 12.9844 9.52148 13.2656Z" fill="#001F6B"/>
                                                </svg>
                                                <p><?php echo wp_kses($bookingpress_paypal_text, $bookingpress_allow_tag); ?></p>
                                                <div class="bpa-front-si-card--checkmark-icon" v-if="appointment_step_form_data.selected_payment_method == 'paypal'">                                                    
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM9.29 16.29 5.7 12.7c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L10 14.17l6.88-6.88c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-7.59 7.59c-.38.39-1.02.39-1.41 0z"/></svg>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                        do_action('bpa_front_add_payment_gateway');
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </el-col>
                    </el-row>
                </div>
                <div class="bpa-front-dc--footer" :class="bookingpress_footer_dynamic_class">
                    <el-row>
                        <el-col>
                            <div class="bpa-front-tabs--foot">
                                <el-button class="bpa-front-btn bpa-front-btn__medium bpa-front-btn--borderless" @click="bookingpress_step_navigation(bookingpress_sidebar_step_data['summary'].previous_tab_name, bookingpress_sidebar_step_data['summary'].next_tab_name, bookingpress_sidebar_step_data['summary'].previous_tab_name)">                                    
                                    <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" viewBox="0 0 24 24"><rect fill="none" height="24" width="24"/><path d="M9.7,18.3L9.7,18.3c0.39-0.39,0.39-1.02,0-1.41L5.83,13H21c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H5.83l3.88-3.88 c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0L2.7,11.3c-0.39,0.39-0.39,1.02,0,1.41l5.59,5.59 C8.68,18.68,9.32,18.68,9.7,18.3z"/></svg>
                                    <?php echo esc_html($bookingpress_goback_btn_text); ?>
                                </el-button>
                                <?php do_action('bookingpress_paypal_payment_button_html'); ?>
                                <el-button v-if="(typeof show_paypal_popup_button != 'undefined' && show_paypal_popup_button == 'false')" class="bpa-front-btn bpa-front-btn__medium bpa-front-btn--primary" :class="(isLoadBookingLoader == '1') ? 'bpa-front-btn--is-loader' : ''" @click="book_appointment" :disabled="isBookingDisabled">                                    
                                    <span class="bpa-btn__label" v-html="bookingpress_book_appointment_btn_text"></span>
                                    <div class="bpa-front-btn--loader__circles">                    
                                      <div></div>
                                      <div></div>
                                      <div></div>
                                     </div>                                    
                                </el-button>
                            </div>
                        </el-col>
                    </el-row>
                </div>
            </div>
        </div><!--end of tab four--> 
    </div>
    <div id="bpa-front-data-empty-view" class="bpa-front-data-empty-view __bpa-is-guest-view" v-if="bookingpress_display_no_service_placeholder == true">
        <svg viewBox="0 0 120 121" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M108.486 103.08C101.042 112.139 86.7296 109.719 75.3575 112.572C64.3105 115.344 53.4388 123.192 42.6284 119.606C31.8342 116.026 27.8283 103.242 20.6455 94.4249C13.5882 85.7617 2.04617 79.3615 0.797986 68.2575C-0.448903 57.1649 8.61128 47.9531 14.3452 38.376C19.5416 29.6967 24.6347 21.093 32.6953 14.9808C41.3289 8.43396 51.0768 2.35675 61.9118 2.30667C72.8285 2.25621 82.086 9.1904 91.5052 14.709C101.484 20.5552 114.441 24.5839 118.451 35.4317C122.456 46.2671 113.129 57.2263 111.445 68.6549C109.732 80.2849 115.949 93.9976 108.486 103.08Z" class="bpa-front-dev__panel-bg"/>
            <g filter="url(#filter0_d_4344_13430)">
                <rect x="16.3105" y="27.8936" width="95.3718" height="22.2173" rx="11.1086" class="bpa-front-dev__form-bg"/>
            </g>
            <circle cx="27.1474" cy="39.0009" r="5.41885" class="bpa-front-dev__primary-bg"/>
            <rect x="37.9863" y="39.542" width="41.1833" height="2.16754" rx="1.08377" fill="#F4F7FB"/>
            <rect x="37.9863" y="36.0215" width="13.5471" height="2.16754" rx="1.08377" fill="#F4F7FB"/>
            <rect x="53.4297" y="36.0215" width="25.7395" height="2.16754" rx="1.08377" fill="#F4F7FB"/>
            <rect x="84.5859" y="34.9375" width="21.6754" height="8.12828" rx="4" fill="#F4F7FB"/>
            <g filter="url(#filter1_d_4344_13430)">
                <rect x="16.3105" y="54.1748" width="95.3718" height="22.2173" rx="11.1086" class="bpa-front-dev__form-bg"/>
            </g>
            <circle cx="27.1474" cy="65.2831" r="5.41885" fill="#E8ECF5"/>
            <rect x="37.9863" y="65.8252" width="41.1833" height="2.16754" rx="1.08377" fill="#E8ECF5"/>
            <rect x="37.9863" y="62.3037" width="13.5471" height="2.16754" rx="1.08377" fill="#DDE1ED"/>
            <rect x="53.4297" y="62.3037" width="25.7395" height="2.16754" rx="1.08377" fill="#E8ECF5"/>
            <rect x="84.5859" y="61.2197" width="21.6754" height="8.12828" rx="4" fill="#F4F7FB"/>
            <g filter="url(#filter2_d_4344_13430)">
                <rect x="16.3105" y="80.4541" width="95.3718" height="22.2173" rx="11.1086" class="bpa-front-dev__form-bg"/>
            </g>
            <circle cx="27.1474" cy="91.5644" r="5.41885" fill="#E8ECF5"/>
            <rect x="37.9863" y="92.1064" width="41.1833" height="2.16754" rx="1.08377" fill="#E8ECF5"/>
            <rect x="37.9863" y="88.582" width="13.5471" height="2.16754" rx="1.08377" fill="#DDE1ED"/>
            <rect x="53.4297" y="88.582" width="25.7395" height="2.16754" rx="1.08377" fill="#E8ECF5"/>
            <rect x="84.5859" y="87.499" width="21.6754" height="8.12828" rx="4" class="bpa-front-dev__primary-bg"/>
            <path d="M10.6699 62.6393C11.3924 62.6393 11.6694 61.9455 11.7176 61.5986C11.7176 62.3164 12.4642 62.6058 12.8375 62.6537C11.9704 62.6537 11.7296 63.3953 11.7176 63.7662C11.7176 62.9623 11.0191 62.6752 10.6699 62.6393Z" stroke="#F4B125" stroke-opacity="0.6" stroke-linejoin="round"/>
            <line x1="11.4707" y1="60.4463" x2="11.4707" y2="60.3625" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round"/>
            <line x1="11.4707" y1="65.8652" x2="11.4707" y2="65.1312" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round"/>
            <path d="M13.4863 62.709H14.7869" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round"/>
            <path d="M8.7207 62.709H9.53353" stroke="#F4B125" stroke-opacity="0.6" stroke-linecap="round"/>
            <path d="M10.3483 40.076L10.35 40.0813H10.3556L10.3511 40.0846L10.3528 40.0898L10.3483 40.0866L10.3438 40.0898L10.3455 40.0846L10.3411 40.0813H10.3466L10.3483 40.076Z" class="bpa-front-dev__primary-bg"/>
            <path d="M117.915 48.4764L117.916 48.4817H117.922L117.917 48.485L117.919 48.4902L117.915 48.487L117.91 48.4902L117.912 48.485L117.907 48.4817H117.913L117.915 48.4764Z" class="bpa-front-dev__primary-bg"/>
            <path d="M84.5866 111.606L84.5883 111.612H84.5938L84.5894 111.615L84.5911 111.62L84.5866 111.617L84.5821 111.62L84.5838 111.615L84.5793 111.612H84.5849L84.5866 111.606Z" stroke="#F5AE41"/>
            <circle cx="56.1379" cy="1.88181" r="0.854713" stroke="#EE2445" stroke-opacity="0.7"/>
            <circle cx="111.681" cy="79.0998" r="0.854713" stroke="#EE2445" stroke-opacity="0.6"/>
            <circle cx="2.76292" cy="79.0993" r="0.854713" stroke="#EE2445" stroke-opacity="0.6"/>
            <circle cx="69.9579" cy="15.9723" r="0.541885" fill="#2166F1"/>
            <line x1="43.9062" y1="16.5115" x2="43.9062" y2="20.0337" stroke="#01CB62" stroke-opacity="0.3"/>
            <line x1="45.3027" y1="18.6365" x2="41.7805" y2="18.6365" stroke="#01CB62" stroke-opacity="0.3"/>
            <line x1="21.3262" y1="105.778" x2="61.9479" y2="105.778" stroke="#DCE4F5" stroke-width="3" stroke-linecap="round"/>
            <line x1="69.0176" y1="105.778" x2="87.9639" y2="105.778" stroke="#DCE4F5" stroke-width="3" stroke-linecap="round"/>
            <line x1="95.8379" y1="105.778" x2="114.784" y2="105.778" stroke="#DCE4F5" stroke-width="3" stroke-linecap="round"/>
            <path d="M92.9902 15.9169C93.8934 15.9169 94.2396 15.0496 94.2998 14.616C94.2998 15.5131 95.233 15.875 95.6997 15.9348C94.6159 15.9348 94.3148 16.8619 94.2998 17.3254C94.2998 16.3206 93.4268 15.9617 92.9902 15.9169Z" stroke="#F4B125" stroke-linejoin="round"/>
            <line x1="94.1113" y1="13.3025" x2="94.1113" y2="12.9478" stroke="#F4B125" stroke-linecap="round"/>
            <line x1="94.1113" y1="20.0769" x2="94.1113" y2="18.9094" stroke="#F4B125" stroke-linecap="round"/>
            <path d="M96.5098 16.0056H98.1354" stroke="#F4B125" stroke-linecap="round"/>
            <path d="M90.5488 16.0056H91.5649" stroke="#F4B125" stroke-linecap="round"/>
            <defs>
                <filter id="filter0_d_4344_13430" x="8.31055" y="21.8936" width="111.372" height="38.2173" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                    <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                    <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                    <feOffset dy="2"/>
                    <feGaussianBlur stdDeviation="4"/>
                    <feComposite in2="hardAlpha" operator="out"/>
                    <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0"/>
                    <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4344_13430"/>
                    <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4344_13430" result="shape"/>
                </filter>
                <filter id="filter1_d_4344_13430" x="8.31055" y="48.1748" width="111.372" height="38.2173" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                    <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                    <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                    <feOffset dy="2"/>
                    <feGaussianBlur stdDeviation="4"/>
                    <feComposite in2="hardAlpha" operator="out"/>
                    <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0"/>
                    <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4344_13430"/>
                    <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4344_13430" result="shape"/>
                </filter>
                <filter id="filter2_d_4344_13430" x="8.31055" y="74.4541" width="111.372" height="38.2173" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                    <feFlood flood-opacity="0" result="BackgroundImageFix"/>
                    <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
                    <feOffset dy="2"/>
                    <feGaussianBlur stdDeviation="4"/>
                    <feComposite in2="hardAlpha" operator="out"/>
                    <feColorMatrix type="matrix" values="0 0 0 0 0.129412 0 0 0 0 0.403922 0 0 0 0 0.945098 0 0 0 0.1 0"/>
                    <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_4344_13430"/>
                    <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_4344_13430" result="shape"/>
                </filter>
            </defs>
        </svg>
        <div class="bpa-front-dev__title"><?php esc_html_e('No categories and services added!', 'bookingpress-appointment-booking'); ?></div>
    </div>
    <div id="bpa-external-script" v-html="bookingpress_external_html"></div>
</div>
